/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.handler.BarOverlayRenderer;
import fuzs.overflowingbars.client.helper.ChatOffsetHelper;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

public class GuiOverlayHandler {
    public static final IGuiOverlay TOUGHNESS_LEVEL = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        ClientConfig.ToughnessRowConfig config = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness;
        if (!config.armorToughnessBar) {
            return;
        }
        Minecraft minecraft = gui.getMinecraft();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            RenderSystem.enableBlend();
            BarOverlayRenderer.renderToughnessLevelBar(guiGraphics, screenWidth, screenHeight, minecraft, config.leftSide ? gui.leftHeight : gui.rightHeight, config.allowCount, config.leftSide, !config.allowLayers);
            RenderSystem.disableBlend();
            if (ChatOffsetHelper.toughnessRow((Player)minecraft.f_91074_)) {
                if (config.leftSide) {
                    gui.leftHeight += 10;
                } else {
                    gui.rightHeight += 10;
                }
            }
        }
    };

    public static void onBeforeRenderGuiOverlay(RenderGuiOverlayEvent.Pre evt) {
        GuiOverlayHandler.handlePlayerHealthOverlay(evt);
        GuiOverlayHandler.handleArmorLevelOverlay(evt);
    }

    private static void handlePlayerHealthOverlay(RenderGuiOverlayEvent.Pre evt) {
        if (evt.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type() && ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.allowLayers) {
            Minecraft minecraft = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)minecraft.f_91065_;
            if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                RenderSystem.enableBlend();
                BarOverlayRenderer.renderHealthLevelBars(evt.getGuiGraphics(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_(), minecraft, gui.leftHeight, ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.allowCount);
                RenderSystem.disableBlend();
                gui.leftHeight = gui.leftHeight + (ChatOffsetHelper.twoHealthRows((Player)minecraft.f_91074_) ? 20 : 10);
            }
            evt.setCanceled(true);
        }
    }

    private static void handleArmorLevelOverlay(RenderGuiOverlayEvent.Pre evt) {
        if (evt.getOverlay() == VanillaGuiOverlay.ARMOR_LEVEL.type() && ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor.allowLayers) {
            Minecraft minecraft = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)minecraft.f_91065_;
            if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                RenderSystem.enableBlend();
                BarOverlayRenderer.renderArmorLevelBar(evt.getGuiGraphics(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_(), minecraft, gui.leftHeight, ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor.allowCount, false);
                RenderSystem.disableBlend();
                if (ChatOffsetHelper.armorRow((Player)minecraft.f_91074_)) {
                    gui.leftHeight += 10;
                }
            }
            evt.setCanceled(true);
        }
    }
}

