/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client;

import de.cristelknight.doapi.client.render.block.StandardBlockEntityRenderer;
import de.cristelknight.doapi.client.render.block.storage.FlowerBoxRenderer;
import de.cristelknight.doapi.client.render.block.storage.FlowerPotBigRenderer;
import de.cristelknight.doapi.client.render.block.storage.api.StorageBlockEntityRenderer;
import de.cristelknight.doapi.client.render.entity.ChairRenderer;
import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import de.cristelknight.doapi.common.registry.DoApiBlocks;
import de.cristelknight.doapi.common.registry.DoApiEntityTypes;
import de.cristelknight.doapi.common.registry.DoApiStorageTypeRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class DoApiClient {
    public static void onClientInit() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{DoApiBlocks.STANDARD.get(), DoApiBlocks.WALL_STANDARD.get()});
        DoApiClient.registerBlockEntityRenderers();
        DoApiClient.registerStorageTypeRenderers();
    }

    public static void preClientInit() {
        DoApiClient.registerModelLayers();
        DoApiClient.registerEntityRenderers();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(DoApiEntityTypes.CHAIR, ChairRenderer::new);
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)DoApiBlockEntityTypes.STORAGE_ENTITY.get()), StorageBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)DoApiBlockEntityTypes.STANDARD.get()), StandardBlockEntityRenderer::new);
    }

    public static void registerModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)StandardBlockEntityRenderer.LAYER_LOCATION, StandardBlockEntityRenderer::createBodyLayer);
    }

    public static void registerStorageTypeRenderers() {
        StorageBlockEntityRenderer.registerStorageType(DoApiStorageTypeRegistry.FLOWER_POT_BIG, new FlowerPotBigRenderer());
        StorageBlockEntityRenderer.registerStorageType(DoApiStorageTypeRegistry.FLOWER_BOX, new FlowerBoxRenderer());
    }
}

