/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.capabilities.targeting.PlayerTargetingData;
import net.turtleboi.turtlecore.capabilities.targeting.PlayerTargetingProvider;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.targeting.TargetS2CPacket;
import net.turtleboi.turtlecore.network.packet.targeting.ToggleLockS2CPacket;

public class TargetingUtils {
    public static double range = 25.0;

    public static LivingEntity getTarget(Player player) {
        Vec3 endVec;
        Vec3 lookVec = player.m_20154_();
        Vec3 startVec = player.m_20299_(1.0f);
        EntityHitResult entityHitResult = TargetingUtils.rayTraceEntity(player, startVec, endVec = startVec.m_82549_(lookVec.m_82490_(range)));
        if (entityHitResult != null && entityHitResult.m_82443_() instanceof LivingEntity) {
            return (LivingEntity)entityHitResult.m_82443_();
        }
        return null;
    }

    public static EntityHitResult rayTraceEntity(Player player, Vec3 startVec, Vec3 endVec) {
        BlockState blockState;
        Level world = player.m_9236_();
        BlockHitResult blockHitResult = world.m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (blockHitResult.m_6662_() != HitResult.Type.MISS && (blockState = world.m_8055_(blockHitResult.m_82425_())).m_60831_((BlockGetter)world, blockHitResult.m_82425_())) {
            endVec = blockHitResult.m_82450_();
        }
        AABB boundingBox = new AABB(startVec, endVec).m_82377_(1.0, 1.0, 1.0);
        List entities = world.m_6443_(LivingEntity.class, boundingBox, e -> e != player);
        EntityHitResult closestEntity = null;
        double closestDistance = range;
        for (LivingEntity entity : entities) {
            double distance;
            AABB entityBoundingBox = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional optionalHit = entityBoundingBox.m_82371_(startVec, endVec);
            if (!optionalHit.isPresent() || !((distance = startVec.m_82554_((Vec3)optionalHit.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = new EntityHitResult((Entity)entity, (Vec3)optionalHit.get());
        }
        return closestEntity;
    }

    public static List<EntityHitResult> rayTraceEntities(Player player, Vec3 startVec, Vec3 endVec) {
        BlockState blockState;
        Level world = player.m_9236_();
        BlockHitResult blockHitResult = world.m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (blockHitResult.m_6662_() != HitResult.Type.MISS && (blockState = world.m_8055_(blockHitResult.m_82425_())).m_60831_((BlockGetter)world, blockHitResult.m_82425_())) {
            endVec = blockHitResult.m_82450_();
        }
        double range = startVec.m_82554_(endVec);
        AABB boundingBox = new AABB(startVec, endVec).m_82377_(1.0, 1.0, 1.0);
        List entities = world.m_6443_(LivingEntity.class, boundingBox, e -> e != player);
        ArrayList<EntityHitResult> hitResults = new ArrayList<EntityHitResult>();
        for (LivingEntity entity : entities) {
            double distance;
            AABB entityBoundingBox = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional optionalHit = entityBoundingBox.m_82371_(startVec, endVec);
            if (!optionalHit.isPresent() || !((distance = startVec.m_82554_((Vec3)optionalHit.get())) <= range)) continue;
            hitResults.add(new EntityHitResult((Entity)entity, (Vec3)optionalHit.get()));
        }
        hitResults.sort(Comparator.comparingDouble(hit -> startVec.m_82554_(hit.m_82450_())));
        return hitResults;
    }

    public static HitResult rayTraceClosest(Player player, Vec3 startVec, Vec3 endVec) {
        Level world = player.m_9236_();
        BlockHitResult blockHitResult = world.m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 closestHitPos = blockHitResult.m_6662_() != HitResult.Type.MISS ? blockHitResult.m_82450_() : endVec;
        double closestDistance = startVec.m_82554_(closestHitPos);
        AABB boundingBox = new AABB(startVec, endVec).m_82400_(1.0);
        List entities = world.m_6443_(LivingEntity.class, boundingBox, e -> e != player);
        BlockHitResult closestEntityHit = null;
        for (LivingEntity entity : entities) {
            Vec3 hitVec;
            double distance;
            AABB entityBoundingBox = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional optionalHit = entityBoundingBox.m_82371_(startVec, endVec);
            if (!optionalHit.isPresent() || !((distance = startVec.m_82554_(hitVec = (Vec3)optionalHit.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntityHit = new EntityHitResult((Entity)entity, hitVec);
        }
        return closestEntityHit != null ? closestEntityHit : blockHitResult;
    }

    public static void toggleLockOn(Player player) {
        if (!TargetingUtils.isLockedOn(player)) {
            LivingEntity target = TargetingUtils.getTarget(player);
            if (target != null) {
                TargetingUtils.setLockedOn(player, true);
                CoreNetworking.sendToPlayer(new ToggleLockS2CPacket(true), (ServerPlayer)player);
                TargetingUtils.setLockedTarget(player, target);
                CoreNetworking.sendToPlayer(new TargetS2CPacket(target), (ServerPlayer)player);
            }
        } else {
            TargetingUtils.resetLockOn(player);
        }
    }

    public static void resetLockOn(Player player) {
        TargetingUtils.setLockedOn(player, false);
        CoreNetworking.sendToPlayer(new ToggleLockS2CPacket(false), (ServerPlayer)player);
        TargetingUtils.setLockedTarget(player, null);
        CoreNetworking.sendToPlayer(new TargetS2CPacket((LivingEntity)null), (ServerPlayer)player);
    }

    public static boolean isLockedOn(Player player) {
        AtomicBoolean result = new AtomicBoolean(false);
        player.getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(targetData -> result.set(targetData.isLockedOn()));
        return result.get();
    }

    public static void setLockedOn(Player player, boolean result) {
        player.getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(targetData -> {
            targetData.setLockedOn(result);
            CoreNetworking.sendToPlayer(new ToggleLockS2CPacket(result), (ServerPlayer)player);
        });
    }

    public static LivingEntity getLockedTarget(Player player) {
        return player.getCapability(PlayerTargetingProvider.PLAYER_TARGET).map(PlayerTargetingData::getLockedTarget).orElse(null);
    }

    public static void setLockedTarget(Player player, LivingEntity entity) {
        player.getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(targetData -> targetData.setLockedTarget(entity));
    }
}

