/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.util;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class PartyUtils {
    private static final String TEAM_PREFIX = "party_";

    public static void createParty(ServerPlayer leader) {
        String teamName;
        Scoreboard scoreboard = leader.m_9236_().m_6188_();
        if (scoreboard.m_83489_(teamName = TEAM_PREFIX + leader.m_20148_()) == null) {
            PlayerTeam team = scoreboard.m_83492_(teamName);
            team.m_83355_(false);
            team.m_83346_(Team.Visibility.ALWAYS);
            team.m_83344_(Team.CollisionRule.NEVER);
            scoreboard.m_6546_(leader.m_7755_().getString(), team);
            leader.m_213846_((Component)Component.m_237113_((String)"Party created. You are the leader."));
        } else {
            leader.m_213846_((Component)Component.m_237113_((String)"You already have a party."));
        }
    }

    public static void invitePlayer(ServerPlayer inviter, ServerPlayer invitee) {
        invitee.m_213846_((Component)Component.m_237113_((String)(inviter.m_7755_().getString() + " has invited you to their party.")));
    }

    public static void acceptInvite(ServerPlayer invitee, ServerPlayer inviter) {
        String teamName;
        Scoreboard scoreboard = inviter.m_9236_().m_6188_();
        PlayerTeam team = scoreboard.m_83489_(teamName = TEAM_PREFIX + inviter.m_20148_());
        if (team != null) {
            scoreboard.m_6546_(invitee.m_7755_().getString(), team);
            invitee.m_213846_((Component)Component.m_237113_((String)("You have joined " + inviter.m_7755_().getString() + "'s party.")));
            inviter.m_213846_((Component)Component.m_237113_((String)(invitee.m_7755_().getString() + " has joined your party.")));
        } else {
            invitee.m_213846_((Component)Component.m_237113_((String)"Failed to join party. The party does not exist."));
        }
    }

    public static void leaveParty(ServerPlayer player) {
        Scoreboard scoreboard = player.m_9236_().m_6188_();
        PlayerTeam team = scoreboard.m_83500_(player.m_7755_().getString());
        if (team != null && team.m_5758_().startsWith(TEAM_PREFIX)) {
            scoreboard.m_6519_(player.m_7755_().getString(), team);
            player.m_213846_((Component)Component.m_237113_((String)"You have left the party."));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"You are not in a party."));
        }
    }

    public static boolean isAlly(ServerPlayer player, ServerPlayer target) {
        Scoreboard scoreboard = player.m_9236_().m_6188_();
        PlayerTeam playerTeam = scoreboard.m_83500_(player.m_7755_().getString());
        PlayerTeam targetTeam = scoreboard.m_83500_(target.m_7755_().getString());
        return playerTeam != null && playerTeam.equals(targetTeam);
    }
}

