/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.event.CooldownResetEvent;

public class CombatUtils {
    private static final Map<Player, Boolean> executeFlagMap = new HashMap<Player, Boolean>();
    public static final Map<Player, ItemStack> executeItemMap = new HashMap<Player, ItemStack>();

    public static void setExecuteFlag(Player player, boolean value, ItemStack item) {
        executeFlagMap.put(player, value);
        executeItemMap.put(player, item);
    }

    public static boolean isExecuteFlagSet(Player player) {
        return executeFlagMap.getOrDefault(player, false);
    }

    public static void clearExecuteFlag(Player player) {
        executeFlagMap.remove(player);
        executeItemMap.remove(player);
    }

    public static void applyExecuteDamage(Player player, LivingEntity target, LivingHurtEvent event, float baseDamage, Runnable executeCooldownReset) {
        if (player == null || target == null) {
            return;
        }
        Level level = player.m_9236_();
        float targetHealth = target.m_21223_();
        float missingHealthPercent = 1.0f - targetHealth / target.m_21233_();
        float bonusMultiplier = Math.min(0.25f + missingHealthPercent, 1.0f);
        float bonusDamage = baseDamage * bonusMultiplier;
        float totalDamage = baseDamage + bonusDamage;
        event.setAmount(totalDamage);
        CombatUtils.spawnExecuteParticle(target);
        if (target.m_21023_((MobEffect)CoreEffects.BLEEDING.get()) && !target.m_21023_((MobEffect)CoreEffects.STUNNED.get())) {
            target.m_7292_(new MobEffectInstance((MobEffect)CoreEffects.STUNNED.get(), 100, 1));
        }
        if (totalDamage >= targetHealth) {
            executeCooldownReset.run();
            level.m_5594_(null, player.m_20097_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.25f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    public static void spawnExecuteParticle(LivingEntity target) {
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public static void resetCooldown(Player player) {
        ItemStack item = executeItemMap.get(player);
        if (item != null) {
            player.m_36335_().m_41527_(item.m_41720_());
        }
        MinecraftForge.EVENT_BUS.post((Event)new CooldownResetEvent(player));
    }
}

