/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.spells;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpellScheduler {
    private static final List<ScheduledSpellCast> spellEffect = new CopyOnWriteArrayList<ScheduledSpellCast>();

    public static void schedule(ServerLevel level, long delayTicks, Runnable spawnTask) {
        long scheduledTime = level.m_46467_() + Math.max(0L, delayTicks);
        spellEffect.add(new ScheduledSpellCast(level, scheduledTime, spawnTask));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<ScheduledSpellCast> scheduledSpellEffects = new ArrayList<ScheduledSpellCast>(spellEffect);
        if (!scheduledSpellEffects.isEmpty()) {
            for (ScheduledSpellCast spellCast : scheduledSpellEffects) {
                long currentTick = spellCast.level.m_46467_();
                if (spellCast.scheduledTick > currentTick) continue;
                spellCast.castTask.run();
                spellEffect.remove(spellCast);
            }
        }
    }

    private record ScheduledSpellCast(ServerLevel level, long scheduledTick, Runnable castTask) {
    }
}

