/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.spells;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.spells.SpellScheduler;

public class ShockwaveSpell {
    private static final ConcurrentHashMap<Long, Set<UUID>> hitPerTick = new ConcurrentHashMap();

    public static void triggerShockwave(LivingEntity sourceEntity, int radius, int scalingLevel) {
        Level level = sourceEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos center = sourceEntity.m_20183_().m_7495_();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos blockPos;
                    BlockState blockState;
                    if (dx * dx + dz * dz > radius * radius || (blockState = serverLevel.m_8055_(blockPos = center.m_7918_(dx, 0, dz))).m_60795_() || blockState.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                    double offsetX = (double)blockPos.m_123341_() + 0.5 - sourceEntity.m_20185_();
                    double offsetZ = (double)blockPos.m_123343_() + 0.5 - sourceEntity.m_20189_();
                    double centerDist = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
                    long delayTicks = (long)centerDist;
                    SpellScheduler.schedule(serverLevel, delayTicks, () -> {
                        long gameTick = serverLevel.m_46467_();
                        Set hitSet = hitPerTick.computeIfAbsent(gameTick, k -> new HashSet());
                        ShockwaveSpell.applyAtBlockOnce(serverLevel, sourceEntity, center, blockPos, radius, centerDist, scalingLevel, hitSet);
                    });
                }
            }
        }
    }

    private static void applyAtBlockOnce(ServerLevel serverLevel, LivingEntity sourceEntity, BlockPos center, BlockPos blockPos, int maxRadius, double centerDist, int scalingLevel, Set<UUID> hitThisTick) {
        double blockY = (double)blockPos.m_123342_() + 1.0;
        AABB hitBox = new AABB((double)blockPos.m_123341_(), blockY - 0.25, (double)blockPos.m_123343_(), (double)blockPos.m_123341_() + 1.0, blockY + 0.75, (double)blockPos.m_123343_() + 1.0).m_82400_(0.5);
        List nearbyEntities = serverLevel.m_45976_(Entity.class, hitBox);
        for (Entity entity : nearbyEntities) {
            UUID uuid;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_7306_((Entity)sourceEntity) || !hitThisTick.add(uuid = livingEntity.m_20148_())) continue;
            Vec3 fromCenter = livingEntity.m_20182_().m_82492_((double)center.m_123341_() + 0.5, sourceEntity.m_20186_(), (double)center.m_123343_() + 0.5);
            Vec3 horizontal = new Vec3(fromCenter.f_82479_, 0.0, fromCenter.f_82481_);
            if (horizontal.m_82556_() < 1.0E-6) continue;
            Vec3 normal = horizontal.m_82541_();
            double knockbackStrength = ShockwaveSpell.computeKnockbackStrength(centerDist, maxRadius, scalingLevel);
            double verticalBoost = 0.15 + 0.05 * serverLevel.f_46441_.m_188500_();
            Vec3 currentMotion = livingEntity.m_20184_();
            Vec3 addedMotion = new Vec3(normal.f_82479_ * knockbackStrength, verticalBoost, normal.f_82481_ * knockbackStrength);
            livingEntity.m_20256_(currentMotion.m_82549_(addedMotion));
            livingEntity.f_19864_ = true;
            float damageAmount = ShockwaveSpell.computeDamageAmount(centerDist, scalingLevel);
            if (!(damageAmount > 0.01f)) continue;
            livingEntity.m_6469_(serverLevel.m_269111_().m_269425_(), damageAmount);
        }
    }

    private static double computeKnockbackStrength(double ringDistance, int maxRadius, int scalingLevel) {
        double distScale = 1.0 - Mth.m_14008_((double)(ringDistance / Math.max(1.0, (double)maxRadius)), (double)0.0, (double)1.0);
        double base = 0.25 + 0.35 * distScale;
        double scalar = Math.max(1.0, 1.0 + 0.25 * (double)scalingLevel);
        return base * scalar;
    }

    private static float computeDamageAmount(double ringDistance, int scalingLevel) {
        float base = 3.0f;
        float falloff = Math.max(1.0f, (float)(3.0 - ringDistance));
        float levelScale = Math.max(1.0f, 1.0f + 0.5f * (float)scalingLevel);
        float damage = base * falloff * levelScale;
        return Math.min(damage, 12.0f);
    }
}

