/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.util.experience;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.turtlecore.network.packet.ClientPacketHandler;

public class SyncExperienceS2CPacket {
    private final int totalExperience;
    private final int experienceLevel;
    private final float experienceProgress;

    public SyncExperienceS2CPacket(int totalExperience, int experienceLevel, float experienceProgress) {
        this.totalExperience = totalExperience;
        this.experienceLevel = experienceLevel;
        this.experienceProgress = experienceProgress;
    }

    public SyncExperienceS2CPacket(FriendlyByteBuf buf) {
        this.totalExperience = buf.readInt();
        this.experienceLevel = buf.readInt();
        this.experienceProgress = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.totalExperience);
        buf.writeInt(this.experienceLevel);
        buf.writeFloat(this.experienceProgress);
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public float getExperienceProgress() {
        return this.experienceProgress;
    }

    public static void handle(SyncExperienceS2CPacket networkPacket, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleExperienceSyncPacket(networkPacket)));
        context.setPacketHandled(true);
    }
}

