/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.util;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SendSoundS2C {
    private final double x;
    private final double y;
    private final double z;
    private final float volume;
    private final float pitch;
    private final boolean distanceDelay;
    private final SoundEvent soundEvent;

    public SendSoundS2C(SoundEvent soundEvent, double x, double y, double z, float volume, float pitch, boolean distanceDelay) {
        this.soundEvent = soundEvent;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
        this.distanceDelay = distanceDelay;
    }

    public SendSoundS2C(FriendlyByteBuf buf) {
        this.soundEvent = (SoundEvent)buf.readRegistryId();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.distanceDelay = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeRegistryId(ForgeRegistries.SOUND_EVENTS, (Object)this.soundEvent);
        this.soundEvent.m_263231_(buf);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.distanceDelay);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                Minecraft.m_91087_().f_91073_.m_7785_(this.x, this.y, this.z, this.soundEvent, SoundSource.AMBIENT, this.volume, this.pitch, this.distanceDelay);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

