/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.util;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.turtlecore.network.packet.ClientPacketHandler;

public class SendParticlesS2C {
    private final double x;
    private final double y;
    private final double z;
    private final double dx;
    private final double dy;
    private final double dz;
    private final ParticleOptions particleType;

    public SendParticlesS2C(ParticleOptions particleType, double x, double y, double z, double dx, double dy, double dz) {
        this.particleType = particleType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    public SendParticlesS2C(FriendlyByteBuf buf) {
        ParticleType type = (ParticleType)buf.readRegistryId();
        this.particleType = type.m_123743_().m_6507_(type, buf);
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.dx = buf.readDouble();
        this.dy = buf.readDouble();
        this.dz = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)this.particleType.m_6012_());
        this.particleType.m_7711_(buf);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.dx);
        buf.writeDouble(this.dy);
        buf.writeDouble(this.dz);
    }

    public ParticleOptions getParticleType() {
        return this.particleType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public double getDz() {
        return this.dz;
    }

    public static boolean handle(SendParticlesS2C networkPacket, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleParticlePacket(networkPacket)));
        context.setPacketHandled(true);
        return true;
    }
}

