/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.targeting;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.turtlecore.network.packet.ClientPacketHandler;

public class TargetS2CPacket {
    private final int targetEntityId;

    public TargetS2CPacket(int targetEntityId) {
        this.targetEntityId = targetEntityId;
    }

    public TargetS2CPacket(LivingEntity targetEntity) {
        this.targetEntityId = targetEntity != null ? targetEntity.m_19879_() : -1;
    }

    public TargetS2CPacket(FriendlyByteBuf buf) {
        this.targetEntityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.targetEntityId);
    }

    public int getTargetEntityId() {
        return this.targetEntityId;
    }

    public static void handle(TargetS2CPacket networkPacket, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleTargetPacket(networkPacket)));
        context.setPacketHandled(true);
    }
}

