/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.targeting;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.targeting.TargetS2CPacket;
import net.turtleboi.turtlecore.util.TargetingUtils;

public class TargetC2SPacket {
    public TargetC2SPacket() {
    }

    public TargetC2SPacket(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                LivingEntity target = TargetingUtils.getTarget((Player)player);
                if (target != null && !TargetingUtils.isLockedOn((Player)player)) {
                    target = TargetingUtils.getTarget((Player)player);
                }
                if (TargetingUtils.isLockedOn((Player)player)) {
                    target = TargetingUtils.getLockedTarget((Player)player);
                } else if (target == null) {
                    TargetingUtils.resetLockOn((Player)player);
                }
                CoreNetworking.sendToPlayer(new TargetS2CPacket(target), player);
            }
        });
        return true;
    }
}

