/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.effects;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.turtlecore.network.packet.ClientPacketHandler;

public class SleepDataS2C {
    private final int entityId;
    private final boolean isAsleep;

    public SleepDataS2C(int entityId, boolean isAsleep) {
        this.entityId = entityId;
        this.isAsleep = isAsleep;
    }

    public SleepDataS2C(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.isAsleep = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.isAsleep);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isAsleep() {
        return this.isAsleep;
    }

    public static boolean handle(SleepDataS2C networkPacket, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleSleepPacket(networkPacket)));
        context.setPacketHandled(true);
        return true;
    }
}

