/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet.effects;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.turtlecore.network.packet.ClientPacketHandler;

public class FrozenDataS2C {
    private final int entityId;
    private final boolean frozen;

    public FrozenDataS2C(int entityId, boolean frozen) {
        this.entityId = entityId;
        this.frozen = frozen;
    }

    public FrozenDataS2C(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.frozen = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.frozen);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public static boolean handle(FrozenDataS2C networkPacket, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleFrozenPacket(networkPacket)));
        context.setPacketHandled(true);
        return true;
    }
}

