/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.network.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.turtleboi.turtlecore.client.data.EffectStatusData;
import net.turtleboi.turtlecore.client.data.TargetingClientData;
import net.turtleboi.turtlecore.network.packet.effects.FrozenDataS2C;
import net.turtleboi.turtlecore.network.packet.effects.SleepDataS2C;
import net.turtleboi.turtlecore.network.packet.targeting.TargetS2CPacket;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;
import net.turtleboi.turtlecore.network.packet.util.experience.ExperienceHandler;
import net.turtleboi.turtlecore.network.packet.util.experience.SyncExperienceS2CPacket;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketHandler {
    private static ExperienceHandler handler;

    public static void handleTargetPacket(TargetS2CPacket networkPacket) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel clientLevel = minecraft.f_91073_;
        if (clientLevel == null) {
            return;
        }
        int targetEntityId = networkPacket.getTargetEntityId();
        if (targetEntityId == -1) {
            TargetingClientData.resetTarget();
        } else {
            Entity entity = clientLevel.m_6815_(targetEntityId);
            if (entity instanceof LivingEntity) {
                TargetingClientData.setTargetId(targetEntityId);
            } else {
                TargetingClientData.resetTarget();
            }
        }
    }

    public static void setHandler(ExperienceHandler experienceHandler) {
        handler = experienceHandler;
    }

    public static void handleExperienceSyncPacket(SyncExperienceS2CPacket networkPacket) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        int total = networkPacket.getTotalExperience();
        int level = networkPacket.getExperienceLevel();
        float progress = networkPacket.getExperienceProgress();
        player.f_36079_ = total;
        player.f_36078_ = level;
        player.f_36080_ = progress;
        if (handler != null) {
            handler.handleExperienceSync(total, level, progress);
        }
    }

    public static void handleParticlePacket(SendParticlesS2C networkPacket) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel clientLevel = minecraft.f_91073_;
        if (clientLevel != null) {
            clientLevel.m_7106_(networkPacket.getParticleType(), networkPacket.getX(), networkPacket.getY(), networkPacket.getZ(), networkPacket.getDx(), networkPacket.getDy(), networkPacket.getDz());
        }
    }

    public static void handleFrozenPacket(FrozenDataS2C networkPacket) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel clientLevel = minecraft.f_91073_;
        if (clientLevel == null) {
            return;
        }
        Entity entity = clientLevel.m_6815_(networkPacket.getEntityId());
        if (entity instanceof LivingEntity) {
            EffectStatusData.setFrozenStatus(networkPacket.getEntityId(), networkPacket.isFrozen());
        }
    }

    public static void handleSleepPacket(SleepDataS2C networkPacket) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel clientLevel = minecraft.f_91073_;
        if (clientLevel == null) {
            return;
        }
        Entity entity = clientLevel.m_6815_(networkPacket.getEntityId());
        if (entity instanceof LivingEntity) {
            EffectStatusData.setFrozenStatus(networkPacket.getEntityId(), networkPacket.isAsleep());
        }
    }
}

