/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.turtleboi.turtlecore.api.IThrownTridentAccessor;
import net.turtleboi.turtlecore.enchantment.CoreEnchantments;
import net.turtleboi.turtlecore.enchantment.SeekingEnchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class MixinAbstractArrow {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void injectTick(CallbackInfo info) {
        AbstractArrow projectile = (AbstractArrow)this;
        Entity owner = projectile.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)owner;
            ItemStack seekerWeapon = shooter.m_21205_();
            int seekingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.SEEKING.get()), (ItemStack)seekerWeapon);
            if (seekingLevel > 0 && (seekerWeapon.m_41720_() instanceof BowItem || seekerWeapon.m_41720_() instanceof CrossbowItem) && shooter instanceof Player) {
                SeekingEnchantment seekingEnchantment;
                Player player = (Player)shooter;
                Object object = CoreEnchantments.SEEKING.get();
                if (object instanceof SeekingEnchantment && (seekingEnchantment = (SeekingEnchantment)((Object)object)).isSeeking((Projectile)projectile)) {
                    seekingEnchantment.applyEffect((LivingEntity)player, (Projectile)projectile, seekingLevel);
                }
            }
            if (projectile instanceof ThrownTrident) {
                ThrownTrident thrownTrident = (ThrownTrident)projectile;
                ItemStack tridentItem = ((IThrownTridentAccessor)thrownTrident).getTridentItem();
                int tridentSeekingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.SEEKING.get()), (ItemStack)tridentItem);
                if (tridentSeekingLevel > 0 && shooter instanceof Player) {
                    SeekingEnchantment seekingEnchantment;
                    Player player = (Player)shooter;
                    Object object = CoreEnchantments.SEEKING.get();
                    if (object instanceof SeekingEnchantment && (seekingEnchantment = (SeekingEnchantment)((Object)object)).isSeeking((Projectile)projectile)) {
                        seekingEnchantment.applyEffect((LivingEntity)player, (Projectile)projectile, tridentSeekingLevel);
                    }
                }
            }
        }
    }

    @Inject(method={"doPostHurtEffects"}, at={@At(value="TAIL")})
    public void injectDoPostHurtEffects(LivingEntity pTarget, CallbackInfo ci) {
        AbstractArrow arrow = (AbstractArrow)this;
        Entity owner = arrow.m_19749_();
        Object object = CoreEnchantments.SEEKING.get();
        if (object instanceof SeekingEnchantment) {
            SeekingEnchantment seekingEnchantment = (SeekingEnchantment)((Object)object);
            if (arrow instanceof ThrownTrident) {
                seekingEnchantment.stopSeeking((Projectile)arrow);
            }
            if (arrow.m_36795_()) {
                seekingEnchantment.stopSeeking((Projectile)arrow);
            }
        }
    }

    @Inject(method={"shoot"}, at={@At(value="TAIL")})
    public void injectShoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy, CallbackInfo ci) {
        AbstractArrow arrow = (AbstractArrow)this;
        Entity owner = arrow.m_19749_();
        Object object = CoreEnchantments.SEEKING.get();
        if (object instanceof SeekingEnchantment) {
            int seekingLevel;
            SeekingEnchantment seekingEnchantment = (SeekingEnchantment)((Object)object);
            if (owner instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)owner;
                ItemStack weaponUsed = shooter.m_21205_();
                if (weaponUsed.m_41619_() || !weaponUsed.m_150930_(Items.f_42717_) && !weaponUsed.m_150930_(Items.f_42411_)) {
                    weaponUsed = shooter.m_21206_();
                }
                if ((seekingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.SEEKING.get()), (ItemStack)weaponUsed)) > 0) {
                    seekingEnchantment.startSeeking((Projectile)arrow);
                }
            }
            if (arrow instanceof ThrownTrident) {
                ThrownTrident thrownTrident = (ThrownTrident)arrow;
                ItemStack tridentItem = ((IThrownTridentAccessor)thrownTrident).getTridentItem();
                seekingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.SEEKING.get()), (ItemStack)tridentItem);
                if (seekingLevel > 0) {
                    seekingEnchantment.startSeeking((Projectile)arrow);
                }
            }
        }
    }
}

