/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.enchantment.CoreEnchantments;
import net.turtleboi.turtlecore.entity.weapons.ThrowableDagger;
import net.turtleboi.turtlecore.init.CoreAttributes;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDaggerItem
extends SwordItem {
    private static final UUID THROWN_DAMAGE_MODIFIER_UUID = UUID.nameUUIDFromBytes("thrown".getBytes());

    public AbstractDaggerItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    protected abstract ResourceLocation getDaggerTexture();

    protected float getThrownDamage() {
        return super.m_43299_() / 2.0f + 0.5f;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)CoreAttributes.THROWN_DAMAGE.get()), (Object)new AttributeModifier(THROWN_DAMAGE_MODIFIER_UUID, "Weapon modifier", (double)this.getThrownDamage(), AttributeModifier.Operation.ADDITION));
            modifiers = builder.build();
        }
        return modifiers;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            float thrownDamage = this.getThrownDamage();
            ThrowableDagger dagger = new ThrowableDagger(level, (LivingEntity)player, itemstack, this.getDaggerTexture(), Float.valueOf(thrownDamage - 1.0f));
            Vec3 direction = player.m_20252_(1.0f);
            double offsetDistance = 0.0;
            double posX = player.m_20185_() + direction.f_82479_ * offsetDistance;
            double posY = player.m_20188_() - (double)0.1f + direction.f_82480_ * offsetDistance;
            double posZ = player.m_20189_() + direction.f_82481_ * offsetDistance;
            dagger.m_6034_(posX, posY, posZ);
            dagger.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 1.0f);
            level.m_7967_((Entity)dagger);
        }
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, @NotNull Enchantment enchantment) {
        if (enchantment == Enchantments.f_44955_ || enchantment == CoreEnchantments.SEEKING.get() || enchantment == CoreEnchantments.RUPTURE.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

