/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.init;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CoreDamageSources {
    public static final ResourceLocation BLEED_DAMAGE_ID = new ResourceLocation("turtlecore", "bleed");
    public static final ResourceLocation FROZEN_DAMAGE_ID = new ResourceLocation("turtlecore", "frozen");

    public static Holder<DamageType> frozenDamageType(Level level) {
        return level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)FROZEN_DAMAGE_ID));
    }

    public static Holder<DamageType> bleedDamageType(Level level) {
        return level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)BLEED_DAMAGE_ID));
    }

    public static DamageSource frozenDamage(Level level, @Nullable Entity attacker, @Nullable Entity directCause) {
        Holder<DamageType> holder = CoreDamageSources.frozenDamageType(level);
        return new DamageSource(holder, attacker, directCause, attacker != null ? attacker.m_20182_() : null);
    }

    public static DamageSource causeBleedDamage(Level level, @Nullable Entity attacker, @Nullable Entity directCause) {
        Holder<DamageType> holder = CoreDamageSources.bleedDamageType(level);
        return new DamageSource(holder, attacker, directCause, attacker != null ? attacker.m_20182_() : null);
    }

    public static boolean isBleedDamage(DamageSource source) {
        return source.m_269150_().equals(CoreDamageSources.bleedDamageType(Objects.requireNonNull(source.m_7639_()).m_9236_()));
    }
}

