/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.init;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="turtlecore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoreAttributes {
    public static final DeferredRegister<Attribute> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"turtlecore");
    public static final RegistryObject<Attribute> RANGED_DAMAGE = CoreAttributes.create("ranged_damage_bonus", 1.0, 1.0);
    public static final RegistryObject<Attribute> COOLDOWN_REDUCTION = CoreAttributes.create("cooldown_reduction", 100.0, 0.0);
    public static final RegistryObject<Attribute> LIFE_STEAL = CoreAttributes.create("life_steal", 0.0, 0.0);
    public static final RegistryObject<Attribute> PLAYER_SIZE = CoreAttributes.create("player_size", 1.0, 0.0);
    public static final RegistryObject<Attribute> CRITICAL_CHANCE = CoreAttributes.create("critical_chance", 5.0, 0.0);
    public static final RegistryObject<Attribute> CRITICAL_DAMAGE = CoreAttributes.create("critical_damage", 1.5, 1.5);
    public static final RegistryObject<Attribute> DAMAGE_RESISTANCE = CoreAttributes.create("damage_resistance", 100.0, 0.0);
    public static final RegistryObject<Attribute> HEALING_EFFECTIVENESS = CoreAttributes.create("healing_effectiveness", 1.0, 0.0);
    public static final RegistryObject<Attribute> ARMOR_PENETRATION = CoreAttributes.create("armor_penetration", 0.0, 0.0);
    public static final RegistryObject<Attribute> DODGE_CHANCE = CoreAttributes.create("dodge_chance", 0.0, 0.0);
    public static final RegistryObject<Attribute> HIT_CHANCE = CoreAttributes.create("hit_chance", 1.0, 0.0);
    public static final RegistryObject<Attribute> THROWN_DAMAGE = CoreAttributes.create("thrown_damage", 0.0, 0.0);
    public static final RegistryObject<Attribute> MAGIC_AMP = CoreAttributes.create("magic_amp", 1.0, 0.0);

    private static RegistryObject<Attribute> create(String name, double defaultValue, double minValue) {
        String descriptionId = "attribute.name.turtlecore." + name;
        return REGISTRY.register(name, () -> new RangedAttribute(descriptionId, defaultValue, minValue, 1024.0).m_22084_(true));
    }

    @SubscribeEvent
    public static void attachAttributes(EntityAttributeModificationEvent event) {
        REGISTRY.getEntries().stream().map(RegistryObject::get).forEach(attribute -> event.add(EntityType.f_20532_, attribute));
    }
}

