/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.init;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public class CoreAttributeModifiers {
    public static UUID generateUUIDFromName(String name) {
        return UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
    }

    public static void applyPermanentModifier(LivingEntity livingEntity, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        UUID uuid = CoreAttributeModifiers.generateUUIDFromName(name);
        AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
        if (attributeInstance != null) {
            AttributeModifier existingModifier = attributeInstance.m_22111_(uuid);
            if (existingModifier != null) {
                attributeInstance.m_22130_(existingModifier);
            }
            attributeInstance.m_22125_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    public static void applyTransientModifier(LivingEntity livingEntity, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        UUID uuid = CoreAttributeModifiers.generateUUIDFromName(name);
        AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
        if (attributeInstance != null) {
            AttributeModifier existingModifier = attributeInstance.m_22111_(uuid);
            if (existingModifier != null) {
                attributeInstance.m_22130_(existingModifier);
            }
            attributeInstance.m_22118_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    public static void removeModifier(LivingEntity livingEntity, Attribute attribute, String name) {
        UUID uuid = CoreAttributeModifiers.generateUUIDFromName(name);
        AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(uuid);
        }
    }

    public static void removeModifierByName(Player player, Attribute attribute, String attributeName) {
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            for (AttributeModifier modifier : attributeInstance.m_22122_()) {
                if (!modifier.m_22214_().contains(attributeName)) continue;
                attributeInstance.m_22120_(modifier.m_22209_());
            }
        }
    }

    public static void removeModifiersByPrefix(LivingEntity livingEntity, Attribute attribute, String prefix) {
        AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22122_().stream().filter(modifier -> modifier.m_22214_().startsWith(prefix)).forEach(arg_0 -> ((AttributeInstance)attributeInstance).m_22130_(arg_0));
        }
    }

    public static void removeModifiersBySuffix(LivingEntity livingEntity, Attribute attribute, String suffix) {
        AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22122_().stream().filter(modifier -> modifier.m_22214_().endsWith(suffix)).forEach(arg_0 -> ((AttributeInstance)attributeInstance).m_22130_(arg_0));
        }
    }
}

