/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.event;

import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.turtlecore.capabilities.party.PlayerParty;
import net.turtleboi.turtlecore.capabilities.party.PlayerPartyProvider;
import net.turtleboi.turtlecore.capabilities.targeting.PlayerTargetingData;
import net.turtleboi.turtlecore.capabilities.targeting.PlayerTargetingProvider;
import net.turtleboi.turtlecore.compat.aspects.AspectsCompat;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.init.CoreDamageSources;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;
import net.turtleboi.turtlecore.util.CombatUtils;
import net.turtleboi.turtlecore.util.TargetingUtils;

@Mod.EventBusSubscriber(modid="turtlecore")
public class CoreEvents {
    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (!((Entity)event.getObject()).getCapability(PlayerPartyProvider.PLAYER_PARTY).isPresent()) {
                event.addCapability(new ResourceLocation("turtlecore", "player_party"), (ICapabilityProvider)new PlayerPartyProvider());
            }
            if (!((Entity)event.getObject()).getCapability(PlayerTargetingProvider.PLAYER_TARGET).isPresent()) {
                event.addCapability(new ResourceLocation("turtlecore", "player_target"), (ICapabilityProvider)new PlayerTargetingProvider(player));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(PlayerPartyProvider.PLAYER_PARTY).ifPresent(oldStore -> event.getEntity().getCapability(PlayerPartyProvider.PLAYER_PARTY).ifPresent(newStore -> newStore.copyFrom((PlayerParty)oldStore)));
            event.getOriginal().getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(oldStore -> event.getEntity().getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(newStore -> newStore.copyFrom((PlayerTargetingData)oldStore)));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().f_46443_ && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TargetingUtils.resetLockOn((Player)player);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity targetEntity = event.getEntity();
        Entity sourceEntity = event.getSource().m_7639_();
        if (targetEntity instanceof Player) {
            player = (Player)targetEntity;
        }
        if (sourceEntity instanceof Player) {
            player = (Player)sourceEntity;
        }
    }

    @SubscribeEvent
    public static void onEntityHurtPost(LivingDamageEvent event) {
        LivingEntity hurtEntity = event.getEntity();
        if (hurtEntity instanceof LivingEntity) {
            MobEffectInstance effectInstance;
            LivingEntity livingEntity = hurtEntity;
            if (livingEntity.m_21023_((MobEffect)CoreEffects.FROZEN.get())) {
                Entity entity;
                effectInstance = livingEntity.m_21124_((MobEffect)CoreEffects.FROZEN.get());
                if (effectInstance != null) {
                    livingEntity.m_21195_((MobEffect)CoreEffects.FROZEN.get());
                }
                float entityMaxHealth = livingEntity.m_21233_();
                int maxDamage = 10;
                if (ModList.get().isLoaded("aspects") && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    double hurtArcaniFactor = AspectsCompat.getArcaniFactor(livingEntity);
                    double glaciusAmplifier = AspectsCompat.getGlaciusAmplifier(attacker);
                    double attackerArcaniFactor = AspectsCompat.getArcaniFactor(attacker);
                    maxDamage = (int)(10.0 + 10.0 * (glaciusAmplifier / 4.0) * attackerArcaniFactor / hurtArcaniFactor);
                }
                hurtEntity.m_6469_(CoreDamageSources.frozenDamage(hurtEntity.m_9236_(), null, null), Math.min((float)maxDamage, entityMaxHealth / 4.0f));
                hurtEntity.m_9236_().m_6263_(null, hurtEntity.m_20185_(), hurtEntity.m_20186_(), hurtEntity.m_20189_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 1.25f, 0.4f / (hurtEntity.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
                double entitySize = hurtEntity.m_20206_() * hurtEntity.m_20205_();
                RandomSource random = hurtEntity.m_9236_().m_213780_();
                int count = (int)(entitySize * 60.0);
                for (int i = 0; i < count; ++i) {
                    double offX = (random.m_188500_() - 0.5) * 0.5;
                    double offY = hurtEntity.m_20206_() / 2.0f;
                    double offZ = (random.m_188500_() - 0.5) * 0.5;
                    double theta = random.m_188500_() * Math.PI;
                    double phi = random.m_188500_() * 2.0 * Math.PI;
                    double speed = 0.5 + random.m_188500_() * 0.5;
                    double xSpeed = speed * Math.sin(theta) * Math.cos(phi);
                    double ySpeed = speed * Math.cos(theta);
                    double zSpeed = speed * Math.sin(theta) * Math.sin(phi);
                    BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_());
                    CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)particle, livingEntity.m_20185_() + offX, livingEntity.m_20186_() + offY, livingEntity.m_20189_() + offZ, xSpeed, ySpeed, zSpeed), livingEntity);
                }
            }
            if (livingEntity.m_21023_((MobEffect)CoreEffects.SLEEP.get()) && (effectInstance = livingEntity.m_21124_((MobEffect)CoreEffects.SLEEP.get())) != null) {
                livingEntity.m_21195_((MobEffect)CoreEffects.SLEEP.get());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerAttack(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity trueSource = source.m_7639_();
        if (!(trueSource instanceof Player)) {
            return;
        }
        Player player = (Player)trueSource;
        LivingEntity target = event.getEntity();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        if (CombatUtils.isExecuteFlagSet(player)) {
            float baseDamage = event.getAmount();
            CombatUtils.applyExecuteDamage(player, target, event, baseDamage, () -> CombatUtils.resetCooldown(player));
            CombatUtils.clearExecuteFlag(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerPlayer serverPlayer = (ServerPlayer)event.player;
            if (event.phase == TickEvent.Phase.START) {
                // empty if block
            }
            if (event.phase == TickEvent.Phase.END) {
                serverPlayer.getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(targetData -> {
                    LivingEntity target = targetData.getLockedTarget();
                    if (targetData.isLockedOn() && (target == null || !target.m_6084_() || !target.isAddedToWorld() || target.m_20280_((Entity)serverPlayer) >= 625.0)) {
                        TargetingUtils.resetLockOn((Player)serverPlayer);
                    }
                });
            }
        }
    }
}

