/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.event;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.turtlecore.client.renderer.FrozenRenderer;
import net.turtleboi.turtlecore.entity.CoreEntities;
import net.turtleboi.turtlecore.entity.client.SanctuaryDomeModel;
import net.turtleboi.turtlecore.entity.client.UnleashFuryModel;
import net.turtleboi.turtlecore.entity.client.renderer.abilities.SanctuaryDomeRenderer;
import net.turtleboi.turtlecore.entity.client.renderer.abilities.UnleashFuryRenderer;
import net.turtleboi.turtlecore.entity.client.renderer.weapons.ThrowableDaggerRenderer;
import net.turtleboi.turtlecore.entity.client.renderer.weapons.ThrowableHandaxeRenderer;
import net.turtleboi.turtlecore.particle.CoreParticles;
import net.turtleboi.turtlecore.particle.custom.ChilledParticles;
import net.turtleboi.turtlecore.particle.custom.HealParticle;
import net.turtleboi.turtlecore.particle.custom.LifeDrainParticles;
import net.turtleboi.turtlecore.particle.custom.SleepParticle;
import net.turtleboi.turtlecore.particle.custom.StunnedParticles;
import net.turtleboi.turtlecore.util.CoreKeyBinding;

@Mod.EventBusSubscriber(modid="turtlecore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CoreClientModBusEvents {
    @SubscribeEvent
    public static void addFrozenLayer(EntityRenderersEvent.AddLayers event) {
        ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entityType -> DefaultAttributes.m_22301_((EntityType)entityType)).filter(entityType -> entityType != EntityType.f_20565_).map(entityType -> entityType).forEach(entityType -> {
            try {
                LivingEntityRenderer renderer = event.getRenderer(entityType);
                if (renderer != null) {
                    renderer.m_115326_(new FrozenRenderer.FrozenLayer(renderer));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        for (String skinType : event.getSkins()) {
            LivingEntityRenderer renderer = event.getSkin(skinType);
            if (renderer == null) continue;
            renderer.m_115326_(new FrozenRenderer.FrozenLayer(renderer));
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)CoreEntities.UNLEASH_FURY.get()), UnleashFuryRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CoreEntities.SANCTUARY_DOME.get()), SanctuaryDomeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CoreEntities.THROWABLE_DAGGER.get()), ThrowableDaggerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CoreEntities.THROWABLE_HANDAXE.get()), ThrowableHandaxeRenderer::new);
    }

    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(CoreKeyBinding.LOCK_ON);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UnleashFuryModel.UNLEASH_FURY_LAYER, UnleashFuryModel::createBodyLayer);
        event.registerLayerDefinition(SanctuaryDomeModel.SANCTUARY_DOME_LAYER, SanctuaryDomeModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)CoreParticles.LIFE_DRAIN_PARTICLES.get(), LifeDrainParticles.Provider::new);
        event.registerSpriteSet((ParticleType)CoreParticles.NONE_PARTICLES.get(), StunnedParticles.Provider::new);
        event.registerSpriteSet((ParticleType)CoreParticles.CHILLED_PARTICLES.get(), ChilledParticles.Provider::new);
        event.registerSpriteSet((ParticleType)CoreParticles.STUNNED_PARTICLES.get(), StunnedParticles.Provider::new);
        event.registerSpriteSet((ParticleType)CoreParticles.HEAL_PARTICLE.get(), HealParticle.Provider::new);
        event.registerSpriteSet((ParticleType)CoreParticles.SLEEP_PARTICLE.get(), SleepParticle.Provider::new);
    }
}

