/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.turtlecore.client.data.TargetingClientData;
import net.turtleboi.turtlecore.client.renderer.TargetArrowRenderer;
import net.turtleboi.turtlecore.client.util.ParticleSpawnQueue;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.effect.effects.SleepEffect;
import net.turtleboi.turtlecore.effect.effects.StunnedEffect;
import net.turtleboi.turtlecore.init.CoreAttributes;
import net.turtleboi.turtlecore.item.weapon.AbstractDaggerItem;
import net.turtleboi.turtlecore.item.weapon.AbstractHandaxeItem;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.targeting.TargetC2SPacket;
import net.turtleboi.turtlecore.network.packet.targeting.ToggleLockC2SPacket;
import net.turtleboi.turtlecore.util.CoreKeyBinding;

public class CoreClientEvents {

    @Mod.EventBusSubscriber(modid="turtlecore", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (CoreKeyBinding.LOCK_ON.m_90859_()) {
                CoreNetworking.sendToServer(new ToggleLockC2SPacket());
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
            if (clientPlayer != null) {
                Object data;
                UUID uuid = clientPlayer.m_20148_();
                if (StunnedEffect.stunnedPlayers.containsKey(uuid)) {
                    data = StunnedEffect.stunnedPlayers.get(uuid);
                    clientPlayer.m_146922_(((StunnedEffect.StunPlayerData)data).savedYaw);
                    clientPlayer.m_146926_(((StunnedEffect.StunPlayerData)data).savedPitch);
                    clientPlayer.f_19859_ = ((StunnedEffect.StunPlayerData)data).savedYaw;
                    clientPlayer.f_19860_ = ((StunnedEffect.StunPlayerData)data).savedPitch;
                }
                if (SleepEffect.sleptPlayers.containsKey(uuid)) {
                    data = SleepEffect.sleptPlayers.get(uuid);
                    clientPlayer.m_146922_(((SleepEffect.SleepPlayerData)data).savedYaw);
                    clientPlayer.m_146926_(((SleepEffect.SleepPlayerData)data).savedPitch);
                    clientPlayer.f_19859_ = ((SleepEffect.SleepPlayerData)data).savedYaw;
                    clientPlayer.f_19860_ = ((SleepEffect.SleepPlayerData)data).savedPitch;
                }
            }
            ParticleSpawnQueue.tick();
        }

        @SubscribeEvent
        public static void onMovementInputUpdate(MovementInputUpdateEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (player.m_21023_((MobEffect)CoreEffects.STUNNED.get()) || player.m_21023_((MobEffect)CoreEffects.FROZEN.get())) || player.m_21023_((MobEffect)CoreEffects.SLEEP.get())) {
                event.getInput().f_108567_ = 0.0f;
                event.getInput().f_108566_ = 0.0f;
                event.getInput().f_108572_ = false;
                event.getInput().f_108573_ = false;
            }
        }

        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (stack.m_41720_() instanceof AbstractDaggerItem || stack.m_41720_() instanceof AbstractHandaxeItem) {
                for (int i = 0; i < event.getToolTip().size(); ++i) {
                    Component tooltipLine = (Component)event.getToolTip().get(i);
                    if (!tooltipLine.getString().contains("Thrown Damage")) continue;
                    String newText = tooltipLine.getString().replace("+", " ");
                    MutableComponent newTooltip = Component.m_237113_((String)newText).m_130940_(ChatFormatting.DARK_GREEN);
                    event.getToolTip().set(i, newTooltip);
                }
            }
        }

        @Mod.EventBusSubscriber(modid="turtlecore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
        public static class RenderEvents {
            @SubscribeEvent
            public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
                Player player = event.getEntity();
                PoseStack poseStack = event.getPoseStack();
                float scale = (float)player.m_21133_((Attribute)CoreAttributes.PLAYER_SIZE.get());
                if (scale != 1.0f) {
                    poseStack.m_85836_();
                    poseStack.m_85841_(scale, scale, scale);
                }
            }

            @SubscribeEvent
            public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
                Minecraft minecraft = Minecraft.m_91087_();
                Player player = event.getEntity();
                PoseStack poseStack = event.getPoseStack();
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                float scale = (float)player.m_21133_((Attribute)CoreAttributes.PLAYER_SIZE.get());
                if (scale != 1.0f) {
                    poseStack.m_85849_();
                }
                bufferSource.m_109911_();
            }

            @SubscribeEvent(priority=EventPriority.HIGHEST)
            public static void onRenderLiving(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
                Minecraft minecraft = Minecraft.m_91087_();
                LocalPlayer player = minecraft.f_91074_;
                if (player != null) {
                    CoreNetworking.sendToServer(new TargetC2SPacket());
                    LivingEntity target = TargetingClientData.getLivingTarget(player.m_9236_());
                    if (target == event.getEntity()) {
                        PoseStack poseStack = event.getPoseStack();
                        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.enableDepthTest();
                        RenderSystem.depthFunc((int)519);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        TargetArrowRenderer.renderTargetArrow(poseStack, (MultiBufferSource)bufferSource, minecraft, (Entity)target, (Player)player);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.disableBlend();
                        RenderSystem.depthFunc((int)515);
                        RenderSystem.disableDepthTest();
                        bufferSource.m_109911_();
                    }
                }
            }
        }
    }
}

