/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.event;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.turtlecore.init.CoreAttributes;
import net.turtleboi.turtlecore.init.CoreDamageSources;
import net.turtleboi.turtlecore.particle.CoreParticles;
import net.turtleboi.turtlecore.util.DamageIdentifierUtil;

@Mod.EventBusSubscriber(modid="turtlecore")
public class CoreAttributeEvents {
    private static final Random RANDOM = new Random();
    private static final double SPEED = 0.1;
    private static final double SIZE = 0.02;
    private static final double SIZE_VARIATION = 0.03;
    private static final double POSITION_VARIATION = 0.1;
    private static final double SPEED_VARIATION = 0.02;

    @SubscribeEvent
    public static void applyAttributeEffects(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CoreAttributeEvents.applyRangedDamageBonus(event, player);
            CoreAttributeEvents.applyLifeSteal(event, player);
            CoreAttributeEvents.applyCriticalHit(event, player);
            CoreAttributeEvents.applyArmorPenetration(event, player);
        } else {
            entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                CoreAttributeEvents.applyDamageResistance(event, player);
                CoreAttributeEvents.applyDodgeChance(event, player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        Player player;
        AttributeInstance healingEffectivenessAttribute;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (healingEffectivenessAttribute = (player = (Player)livingEntity).m_21051_((Attribute)CoreAttributes.HEALING_EFFECTIVENESS.get())) != null) {
            double healingEffectiveness = healingEffectivenessAttribute.m_22135_();
            float originalHealAmount = event.getAmount();
            float adjustedHealAmount = (float)((double)originalHealAmount * healingEffectiveness);
            event.setAmount(adjustedHealAmount);
        }
    }

    private static void applyRangedDamageBonus(LivingHurtEvent event, Player player) {
        AttributeInstance rangedBonusAttribute = player.m_21051_((Attribute)CoreAttributes.RANGED_DAMAGE.get());
        if (rangedBonusAttribute != null && DamageIdentifierUtil.isRangedDamage(event.getSource())) {
            double rangedBonus = rangedBonusAttribute.m_22135_();
            float newDamage = (float)((double)event.getAmount() + rangedBonus);
            event.setAmount(newDamage);
        }
    }

    private static void applyLifeSteal(LivingHurtEvent event, Player player) {
        AttributeInstance lifeStealAttribute;
        if ((CoreAttributeEvents.isMeleeAttack(event, player) || CoreAttributeEvents.isPlayerAppliedBleed(event, player)) && (lifeStealAttribute = player.m_21051_((Attribute)CoreAttributes.LIFE_STEAL.get())) != null && lifeStealAttribute.m_22135_() > 0.0) {
            double lifeStealPercentage = lifeStealAttribute.m_22135_() / 100.0;
            float damage = event.getAmount();
            float healAmount = CoreAttributeEvents.getHealAmount(event, damage, (float)lifeStealPercentage);
            if (healAmount > 0.0f) {
                player.m_5634_(healAmount);
                CoreAttributeEvents.spawnLifeDrainParticles(event.getEntity(), player, healAmount);
            }
        }
    }

    private static boolean isMeleeAttack(LivingHurtEvent event, Player player) {
        return event.getSource().m_7639_() == player && event.getSource().m_7640_() == player;
    }

    private static boolean isPlayerAppliedBleed(LivingHurtEvent event, Player player) {
        Entity source;
        if ("bleed".equals(event.getSource().m_19385_()) && (source = event.getSource().m_7639_()) instanceof Player) {
            return source == player;
        }
        return false;
    }

    private static void applyCriticalHit(LivingHurtEvent event, Player player) {
        AttributeInstance critChanceAttribute = player.m_21051_((Attribute)CoreAttributes.CRITICAL_CHANCE.get());
        AttributeInstance critDamageAttribute = player.m_21051_((Attribute)CoreAttributes.CRITICAL_DAMAGE.get());
        if (critChanceAttribute != null && critDamageAttribute != null) {
            int chance;
            int critChance = (int)critChanceAttribute.m_22135_();
            double critDamage = critDamageAttribute.m_22135_();
            if (critChance > 100) {
                int excessCritChance = critChance - 100;
                critDamage += 0.1 * (double)excessCritChance;
            }
            if ((chance = new Random().nextInt(100) + 1) <= critChance) {
                float originalDamage = event.getAmount();
                float newDamage = (float)((double)originalDamage * critDamage);
                event.setAmount(newDamage);
                LivingEntity target = event.getEntity();
                Level level = target.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 2; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 20, 0.5, 0.5, 0.5, 0.1);
                    }
                }
            }
        }
    }

    private static void applyDamageResistance(LivingHurtEvent event, Player player) {
        AttributeInstance damageResistanceAttribute = player.m_21051_((Attribute)CoreAttributes.DAMAGE_RESISTANCE.get());
        if (damageResistanceAttribute != null) {
            double damageResistance = damageResistanceAttribute.m_22135_() / 100.0;
            float originalDamage = event.getAmount();
            float reducedDamage = (float)((double)originalDamage * damageResistance);
            event.setAmount(reducedDamage);
        }
    }

    private static void applyArmorPenetration(LivingHurtEvent event, Player player) {
        AttributeInstance armorPenAttribute = player.m_21051_((Attribute)CoreAttributes.ARMOR_PENETRATION.get());
        if (armorPenAttribute != null) {
            double armorPenetration = armorPenAttribute.m_22135_();
            LivingEntity target = event.getEntity();
            float originalDamage = event.getAmount();
            float armorValue = target.m_21230_();
            float effectiveArmor = Math.max(0.0f, armorValue - (float)armorPenetration);
            float damageAfterArmor = originalDamage * (1.0f - Math.min(20.0f, effectiveArmor) / 25.0f);
            event.setAmount(damageAfterArmor);
        }
    }

    private static void applyDodgeChance(LivingHurtEvent event, Player player) {
        AttributeInstance dodgeChanceAttribute = player.m_21051_((Attribute)CoreAttributes.DODGE_CHANCE.get());
        if (dodgeChanceAttribute != null) {
            double dodgeChance = dodgeChanceAttribute.m_22135_();
            Random random = new Random();
            double randomValue = random.nextDouble() * 100.0;
            if (randomValue < dodgeChance) {
                event.setCanceled(true);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_213846_((Component)Component.m_237113_((String)"Dodged the attack!"));
            }
        }
    }

    private static float getHealAmount(LivingHurtEvent event, float damage, float lifeLeechPercentage) {
        float healAmount = 0.0f;
        if (CoreDamageSources.isBleedDamage(event.getSource())) {
            healAmount = 1.0f;
        } else if (!(DamageIdentifierUtil.isProjectile(event.getSource()) || DamageIdentifierUtil.isExplosion(event.getSource()) || DamageIdentifierUtil.isMagic(event.getSource()))) {
            healAmount = damage * lifeLeechPercentage;
        }
        return healAmount;
    }

    private static void spawnLifeDrainParticles(LivingEntity targetEntity, Player player, float healAmount) {
        if (!player.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)player.m_9236_();
            double targetX = targetEntity.m_20185_();
            double targetY = targetEntity.m_20186_() + (double)targetEntity.m_20192_() / 2.0;
            double targetZ = targetEntity.m_20189_();
            double playerX = player.m_20185_();
            double playerY = player.m_20186_() + (double)player.m_20192_() / 2.0;
            double playerZ = player.m_20189_();
            double dx = playerX - targetX;
            double dy = playerY - targetY;
            double dz = playerZ - targetZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            int particlesPerHealth = 8;
            int numberOfParticles = (int)(healAmount * (float)particlesPerHealth);
            if (numberOfParticles > 0) {
                double interval = distance / (double)numberOfParticles;
                for (int i = 0; i < numberOfParticles; ++i) {
                    double size = 0.02 + RANDOM.nextDouble() * 0.03;
                    double progress = interval * (double)i;
                    double xPos = targetX + dx * (progress / distance) + (RANDOM.nextDouble() - 0.5) * 0.1;
                    double yPos = targetY + dy * (progress / distance) + (RANDOM.nextDouble() - 0.5) * 0.1;
                    double zPos = targetZ + dz * (progress / distance) + (RANDOM.nextDouble() - 0.5) * 0.1;
                    double xSpeed = dx * 0.1 / distance + (RANDOM.nextDouble() - 0.5) * 0.02;
                    double ySpeed = dy * 0.1 / distance + (RANDOM.nextDouble() - 0.5) * 0.02;
                    double zSpeed = dz * 0.1 / distance + (RANDOM.nextDouble() - 0.5) * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CoreParticles.LIFE_DRAIN_PARTICLES.get()), xPos, yPos, zPos, 1, xSpeed, ySpeed, zSpeed, size);
                }
            }
        }
    }
}

