/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.entity.weapons;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.enchantment.CoreEnchantments;
import net.turtleboi.turtlecore.enchantment.RuptureEnchantment;
import net.turtleboi.turtlecore.enchantment.SeekingEnchantment;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractThrowableWeapon
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> HIT_BLOCK = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> ROTATE_VARIATION = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> SEEKING_LEVEL = SynchedEntityData.m_135353_(AbstractThrowableWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected ItemStack weaponItem = ItemStack.f_41583_;
    private boolean dealtDamage = false;
    private BlockState lastState;
    private BlockPos hitBlockPos;
    public float lastYP = 0.0f;
    public float lastZP = 0.0f;
    private int returnTickCount = 0;

    public AbstractThrowableWeapon(EntityType<? extends AbstractThrowableWeapon> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractThrowableWeapon(EntityType<? extends AbstractThrowableWeapon> entityType, Level level, LivingEntity thrower, ItemStack itemStack, ResourceLocation resourceLocation, Float thrownDamage) {
        super(entityType, thrower, level);
        if (itemStack != null && this.weaponItem.m_41619_()) {
            this.weaponItem = itemStack.m_41777_();
        }
        this.f_19804_.m_135381_(ITEM_STACK, (Object)this.weaponItem);
        this.f_19804_.m_135381_(TEXTURE, (Object)resourceLocation.toString());
        this.f_19804_.m_135381_(ID_FOIL, (Object)this.weaponItem.m_41790_());
        this.f_19804_.m_135381_(DAMAGE, (Object)thrownDamage);
        this.f_19804_.m_135381_(HIT_BLOCK, (Object)false);
        this.f_19804_.m_135381_(RETURNING, (Object)false);
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.weaponItem)));
        this.f_19804_.m_135381_(SEEKING_LEVEL, (Object)((byte)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.SEEKING.get()), (ItemStack)this.weaponItem)));
        float rotateVariation = 1.0f + level.f_46441_.m_188501_() * 24.0f;
        this.f_19804_.m_135381_(ROTATE_VARIATION, (Object)Float.valueOf(rotateVariation));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(TEXTURE, (Object)"");
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HIT_BLOCK, (Object)false);
        this.f_19804_.m_135372_(RETURNING, (Object)false);
        this.f_19804_.m_135372_(ROTATE_VARIATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(SEEKING_LEVEL, (Object)0);
    }

    public float getWeaponDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation((String)this.f_19804_.m_135370_(TEXTURE));
    }

    public float getRotateVariation() {
        return ((Float)this.f_19804_.m_135370_(ROTATE_VARIATION)).floatValue();
    }

    public byte getLoyaltyLevel() {
        return (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(RETURNING);
    }

    public byte getSeekingLevel() {
        return (Byte)this.f_19804_.m_135370_(SEEKING_LEVEL);
    }

    public void m_8119_() {
        super.m_8119_();
        this.weaponItem = (ItemStack)this.f_19804_.m_135370_(ITEM_STACK);
        Player owner = (Player)this.m_19749_();
        if (owner == null) {
            return;
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (!this.m_9236_().f_46443_) {
            SeekingEnchantment seekingEnchantment;
            Object object;
            int seekingLevel;
            if (this.weaponItem != null && !this.weaponItem.m_41619_() && (seekingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.SEEKING.get()), (ItemStack)this.weaponItem)) > 0 && (object = CoreEnchantments.SEEKING.get()) instanceof SeekingEnchantment && (seekingEnchantment = (SeekingEnchantment)((Object)object)).isSeeking((Projectile)this)) {
                seekingEnchantment.applyEffect((LivingEntity)owner, (Projectile)this, seekingLevel);
            }
            if (this.m_36798_()) {
                this.m_36799_();
            }
            if (this.getLoyaltyLevel() > 0 && (this.dealtDamage || this.hasHitBlock())) {
                if (!this.isAcceptableReturnOwner()) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                    this.m_146870_();
                } else {
                    this.f_19804_.m_135381_(RETURNING, (Object)true);
                    ++this.returnTickCount;
                    this.m_20242_(true);
                    this.m_36790_(true);
                    Vec3 vec3 = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20188_() - 1.0 - this.m_20186_(), owner.m_20189_() - this.m_20189_());
                    this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)this.getLoyaltyLevel(), this.m_20189_());
                    if (this.m_9236_().f_46443_) {
                        this.f_19791_ = this.m_20186_();
                    }
                    double d0 = 0.1 * (double)this.getLoyaltyLevel();
                    this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                    if (this.returnTickCount == 0) {
                        this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                    }
                    if (this.isReturning() && (double)this.m_20270_((Entity)owner) < 1.0 && !this.m_9236_().f_46443_ && this.dealtDamage && this.m_6084_() && this.tickCount() > 20) {
                        owner.m_7938_((Entity)this, 1);
                        owner.m_150109_().m_36054_(this.m_7941_());
                        this.m_146870_();
                    }
                }
            }
        }
    }

    private boolean isAcceptableReturnOwner() {
        Entity owner = this.m_19749_();
        return owner != null && owner.m_6084_() && !owner.m_5833_();
    }

    public boolean m_36798_() {
        if (this.hitBlockPos == null) {
            return false;
        }
        if (this.hasHitBlock() && !this.f_36703_) {
            BlockState currentState = this.m_9236_().m_8055_(this.hitBlockPos);
            return !currentState.equals(this.lastState) || currentState.m_60795_();
        }
        return false;
    }

    private void m_36799_() {
        this.m_20242_(false);
        this.m_20256_(new Vec3(0.0, -0.25, 0.0));
    }

    public void m_6686_(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Object object;
        super.m_6686_(pX, pY, pZ, pVelocity, pInaccuracy);
        if (this.getSeekingLevel() > 0 && (object = CoreEnchantments.SEEKING.get()) instanceof SeekingEnchantment) {
            SeekingEnchantment seekingEnchantment = (SeekingEnchantment)((Object)object);
            seekingEnchantment.startSeeking((Projectile)this);
        }
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        if (this.isReturning()) {
            this.f_19804_.m_135381_(HIT_BLOCK, (Object)true);
        } else {
            this.f_19804_.m_135381_(HIT_BLOCK, (Object)true);
            this.lastState = this.m_9236_().m_8055_(blockHitResult.m_82425_());
            this.hitBlockPos = blockHitResult.m_82425_();
            Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20256_(vec3);
            Vec3 adjustment = vec3.m_82541_().m_82490_((double)0.05f);
            this.m_20343_(this.m_20185_() - adjustment.f_82479_, this.m_20186_() - adjustment.f_82480_, this.m_20189_() - adjustment.f_82481_);
            this.m_20242_(true);
            this.f_36703_ = true;
            this.m_5496_(SoundEvents.f_12515_, 10.0f, 1.0f);
        }
        this.dealtDamage = true;
    }

    public boolean hasHitBlock() {
        return (Boolean)this.f_19804_.m_135370_(HIT_BLOCK);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        if (!this.isReturning()) {
            Entity owner = this.m_19749_();
            Entity target = result.m_82443_();
            float damage = this.getWeaponDamage();
            if (target instanceof LivingEntity) {
                Object object;
                int ruptureLevel;
                LivingEntity livingTarget = (LivingEntity)target;
                damage += EnchantmentHelper.m_44833_((ItemStack)this.weaponItem, (MobType)livingTarget.m_6336_());
                int fireAspectLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44981_, (ItemStack)this.weaponItem);
                if (fireAspectLevel > 0) {
                    livingTarget.m_20254_(fireAspectLevel * 4);
                }
                if ((ruptureLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)CoreEnchantments.RUPTURE.get()), (ItemStack)this.weaponItem)) > 0 && (object = CoreEnchantments.RUPTURE.get()) instanceof RuptureEnchantment) {
                    RuptureEnchantment ruptureEnchantment = (RuptureEnchantment)((Object)object);
                    ruptureEnchantment.applyEffect(livingTarget, (LivingEntity)owner, ruptureLevel);
                }
            }
            if (!this.dealtDamage) {
                DamageSource source = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268425_), (Entity)this, (Entity)(owner == null ? this : owner));
                if (target.m_6469_(source, damage)) {
                    if (target instanceof LivingEntity) {
                        Object object;
                        assert (owner != null);
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)target), (Entity)owner);
                        EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)target);
                        if (this.getSeekingLevel() > 0 && (object = CoreEnchantments.SEEKING.get()) instanceof SeekingEnchantment) {
                            SeekingEnchantment seekingEnchantment = (SeekingEnchantment)((Object)object);
                            seekingEnchantment.stopSeeking((Projectile)this);
                        }
                    }
                    this.dealtDamage = true;
                }
                if (!this.m_9236_().f_46443_) {
                    this.weaponItem.m_41622_(1, (LivingEntity)this.m_19749_(), player -> {
                        player.m_21190_(player.m_7655_());
                        this.m_5496_(SoundEvents.f_12018_, 10.0f, 1.0f);
                    });
                    this.f_19804_.m_135381_(ITEM_STACK, (Object)this.weaponItem.m_41777_());
                    if (this.weaponItem.m_41619_()) {
                        this.m_146870_();
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
            this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        }
    }

    public void m_7761_(@NotNull LivingEntity target) {
        super.m_7761_(target);
    }

    public void m_6123_(@NotNull Player player) {
        Entity owner = this.m_19749_();
        if (!this.m_9236_().f_46443_ && this.dealtDamage && this.m_6084_() && this.tickCount() > 20 && player == owner) {
            player.m_7938_((Entity)this, 1);
            player.m_150109_().m_36054_(this.m_7941_());
            this.m_146870_();
        }
    }

    @NotNull
    public ItemStack m_7941_() {
        if (this.weaponItem.m_41619_()) {
            return this.getDefaultWeaponItem();
        }
        return this.weaponItem.m_41777_();
    }

    protected abstract ItemStack getDefaultWeaponItem();

    private int tickCount() {
        return this.f_19797_;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_(this.getWeaponTagName(), (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        compound.m_128379_("DealtDamage", this.dealtDamage);
        compound.m_128379_("HitBlock", ((Boolean)this.f_19804_.m_135370_(HIT_BLOCK)).booleanValue());
        compound.m_128379_("Returning", ((Boolean)this.f_19804_.m_135370_(RETURNING)).booleanValue());
        compound.m_128350_("LastYP", this.lastYP);
        compound.m_128350_("LastZP", this.lastZP);
        compound.m_128350_("RotateVariation", ((Float)this.f_19804_.m_135370_(ROTATE_VARIATION)).floatValue());
        compound.m_128344_("LoyaltyLevel", this.getLoyaltyLevel());
        compound.m_128344_("SeekingLevel", this.getSeekingLevel());
        if (!((String)this.f_19804_.m_135370_(TEXTURE)).isEmpty()) {
            compound.m_128359_("Texture", (String)this.f_19804_.m_135370_(TEXTURE));
        }
        compound.m_128350_("Damage", ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(this.getWeaponTagName(), 10)) {
            this.weaponItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_(this.getWeaponTagName()));
        }
        this.dealtDamage = compound.m_128471_("DealtDamage");
        if (compound.m_128441_("HitBlock")) {
            this.f_19804_.m_135381_(HIT_BLOCK, (Object)compound.m_128471_("HitBlock"));
        }
        if (compound.m_128441_("Returning")) {
            this.f_19804_.m_135381_(RETURNING, (Object)compound.m_128471_("Returning"));
        }
        if (compound.m_128441_("LastYP")) {
            this.lastYP = compound.m_128457_("LastYP");
        }
        if (compound.m_128441_("LastZP")) {
            this.lastZP = compound.m_128457_("LastZP");
        }
        if (compound.m_128441_("RotateVariation")) {
            this.f_19804_.m_135381_(ROTATE_VARIATION, (Object)Float.valueOf(compound.m_128457_("RotateVariation")));
        }
        if (compound.m_128441_("LoyaltyLevel")) {
            this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)compound.m_128445_("LoyaltyLevel"));
        }
        if (compound.m_128441_("SeekingLevel")) {
            this.f_19804_.m_135381_(SEEKING_LEVEL, (Object)compound.m_128445_("SeekingLevel"));
        }
        this.f_19804_.m_135381_(ID_FOIL, (Object)this.weaponItem.m_41790_());
        if (compound.m_128425_("Texture", 8)) {
            this.f_19804_.m_135381_(TEXTURE, (Object)compound.m_128461_("Texture"));
        }
        if (compound.m_128425_("Damage", 5)) {
            this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(compound.m_128457_("Damage")));
        }
        this.f_19804_.m_135381_(ITEM_STACK, (Object)this.weaponItem);
    }

    protected abstract String getWeaponTagName();
}

