/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.entity.abilities;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.turtleboi.turtlecore.util.PartyUtils;

public class SanctuaryDomeEntity
extends Entity {
    private static final Set<MobCategory> ALLOWED_CATEGORIES = EnumSet.of(MobCategory.AMBIENT, MobCategory.CREATURE, MobCategory.AXOLOTLS, MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.WATER_CREATURE);
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(SanctuaryDomeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Player owner;
    private double radius = 4.0;
    private int healTicks;
    public double growthFactor = 0.0;
    public float alpha = 0.75f;

    public SanctuaryDomeEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_146915_(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_ID, (Object)0);
    }

    public void setOwner(Player owner) {
        this.owner = owner;
        this.f_19804_.m_135381_(OWNER_ID, (Object)owner.m_19879_());
        this.m_20242_(true);
        this.m_20331_(true);
    }

    public Player getOwner() {
        if (this.m_9236_().f_46443_) {
            return (Player)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(OWNER_ID)).intValue());
        }
        return this.owner;
    }

    private boolean isAllowedCategory(MobCategory category) {
        return ALLOWED_CATEGORIES.contains(category);
    }

    public double getRadius() {
        return this.radius;
    }

    public double getGrowthFactor() {
        return this.growthFactor;
    }

    public void m_8119_() {
        super.m_8119_();
        Player currentOwner = this.getOwner();
        if (currentOwner == null || !currentOwner.m_6084_()) {
            this.m_146870_();
            return;
        }
        this.growthFactor = this.f_19797_ < 10 ? (double)this.f_19797_ / 10.0 : 1.0;
        if (this.f_19797_ >= 160 && this.f_19797_ < 220) {
            float oscillation = 0.25f * (float)Math.sin((double)(this.f_19797_ - 160) / 5.0);
            this.alpha = 0.75f + oscillation;
        } else {
            this.alpha = this.f_19797_ >= 220 ? 0.75f * (1.0f - (float)(this.f_19797_ - 220) / 20.0f) : 0.75f;
        }
        double currentRadius = this.radius * this.growthFactor;
        if (!this.m_9236_().m_5776_()) {
            List nearbyEntities = this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(currentRadius));
            for (Entity entity : nearbyEntities) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    MobCategory category = entity.m_6095_().m_20674_();
                    if (this.isAlly(this.owner, entity) || entity == this.owner || this.isAllowedCategory(category)) {
                        ++this.healTicks;
                        if (this.healTicks < 20) continue;
                        livingEntity.m_5634_(3.0f);
                        this.healTicks = 0;
                        continue;
                    }
                    this.repelEntityFromDome(livingEntity, currentRadius);
                    continue;
                }
                if (!(entity instanceof Projectile) || !this.isHostileProjectile(entity, currentOwner)) continue;
                this.repelProjectileFromDome(entity, currentRadius);
            }
        }
        if (this.f_19797_ > 240) {
            this.m_146870_();
        }
    }

    private boolean isAlly(Player player, Entity entity) {
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (targetPlayer instanceof ServerPlayer) {
                    ServerPlayer serverTargetPlayer = (ServerPlayer)targetPlayer;
                    return PartyUtils.isAlly(serverPlayer, serverTargetPlayer);
                }
            }
        }
        return false;
    }

    private void repelEntityFromDome(LivingEntity entity, double currentRadius) {
        double dz;
        double dx = entity.m_20185_() - this.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = entity.m_20189_() - this.m_20189_()) * dz);
        if (distance < currentRadius) {
            double repelStrength = 1.0 / distance * 0.5 + 0.2;
            double norm = Math.sqrt(dx * dx + dz * dz);
            entity.m_20334_((dx /= norm) * repelStrength, entity.m_20184_().f_82480_, (dz /= norm) * repelStrength);
        }
    }

    private void repelProjectileFromDome(Entity entity, double currentRadius) {
        double dz;
        double dx = entity.m_20185_() - this.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = entity.m_20189_() - this.m_20189_()) * dz);
        if (distance < currentRadius) {
            double newDx = -entity.m_20184_().f_82479_;
            double newDz = -entity.m_20184_().f_82481_;
            entity.m_20334_(newDx, entity.m_20184_().f_82480_, newDz);
            double speedMultiplier = 1.5;
            entity.m_20256_(entity.m_20184_().m_82490_(speedMultiplier));
            entity.m_6034_(entity.m_20185_() + newDx * 0.1, entity.m_20186_(), entity.m_20189_() + newDz * 0.1);
        }
    }

    private boolean isHostileProjectile(Entity entity, Player owner) {
        if (entity instanceof Projectile) {
            LivingEntity livingShooter;
            Projectile projectile = (Projectile)entity;
            Entity shooter = projectile.m_19749_();
            return shooter != owner && shooter instanceof LivingEntity && !this.isAlly(owner, (Entity)(livingShooter = (LivingEntity)shooter));
        }
        return false;
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

