/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.enchantment;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.capabilities.targeting.PlayerTargetingProvider;
import org.jetbrains.annotations.NotNull;

public class SeekingEnchantment
extends Enchantment {
    private final Map<Projectile, Boolean> projectileSeekingMap = new HashMap<Projectile, Boolean>();

    public SeekingEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot ... slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 10 + 30 * (level - 1);
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 2;
    }

    public void applyEffect(LivingEntity shooter, Projectile projectile, int level) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            player.getCapability(PlayerTargetingProvider.PLAYER_TARGET).ifPresent(targetData -> {
                LivingEntity target = targetData.getLockedTarget();
                if (target != null) {
                    // empty if block
                }
                if (target != null && target.m_6084_() && !(target instanceof EnderMan)) {
                    if (this.isSeeking(projectile)) {
                        projectile.m_20242_(true);
                        Vec3 direction = new Vec3(target.m_20185_() - projectile.m_20185_(), target.m_20188_() - 0.5 - projectile.m_20186_(), target.m_20189_() - projectile.m_20189_()).m_82541_();
                        double resetSpeed = 0.5 * (double)level;
                        Vec3 newVelocity = direction.m_82490_(resetSpeed);
                        projectile.m_20256_(newVelocity);
                    } else {
                        projectile.m_20242_(false);
                    }
                } else {
                    projectile.m_20242_(false);
                    if (target == null || !target.m_6084_() || target instanceof EnderMan) {
                        // empty if block
                    }
                }
                projectile.m_20242_(false);
            });
        }
    }

    public void startSeeking(Projectile projectile) {
        this.projectileSeekingMap.put(projectile, true);
    }

    public void stopSeeking(Projectile projectile) {
        this.projectileSeekingMap.put(projectile, false);
    }

    public boolean isSeeking(Projectile projectile) {
        return this.projectileSeekingMap.getOrDefault(projectile, false);
    }

    public boolean m_5975_(@NotNull Enchantment enchantment) {
        return super.m_5975_(enchantment) && enchantment != Enchantments.f_44961_;
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42411_) || itemStack.m_150930_(Items.f_42717_) || itemStack.m_150930_(Items.f_42713_) || super.canApplyAtEnchantingTable(itemStack);
    }
}

