/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.enchantment;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.turtleboi.turtlecore.effect.effects.BleedEffect;
import org.jetbrains.annotations.NotNull;

public class RuptureEnchantment
extends Enchantment {
    public RuptureEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot ... slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 20 + 10 * (level - 1);
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public void m_7677_(@NotNull LivingEntity user, @NotNull Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            this.applyEffect(livingTarget, user, level);
        }
    }

    public void applyEffect(LivingEntity targetEntity, LivingEntity sourceEntity, int level) {
        BleedEffect.applyOrAmplifyBleed(targetEntity, 100, level - 1, (Entity)sourceEntity);
    }

    public boolean m_5975_(@NotNull Enchantment enchantment) {
        return super.m_5975_(enchantment) && enchantment != Enchantments.f_44981_ && enchantment != Enchantments.f_44990_;
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42411_) || itemStack.m_150930_(Items.f_42717_) || itemStack.m_150930_(Items.f_42713_) || super.canApplyAtEnchantingTable(itemStack);
    }
}

