/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.effect.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.turtleboi.turtlecore.compat.aspects.AspectsCompat;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;
import net.turtleboi.turtlecore.particle.CoreParticles;

public class StunnedEffect
extends MobEffect {
    public static final Map<UUID, StunPlayerData> stunnedPlayers = new HashMap<UUID, StunPlayerData>();

    public StunnedEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        MobEffectInstance originalInstance;
        Player stunningPlayer = StunnedEffect.getStunner(pLivingEntity);
        if (pLivingEntity.m_21023_((MobEffect)CoreEffects.STUNNED.get()) && (originalInstance = pLivingEntity.m_21124_((MobEffect)CoreEffects.STUNNED.get())).m_19572_()) {
            originalInstance.m_19558_(new MobEffectInstance((MobEffect)CoreEffects.STUNNED.get(), originalInstance.m_19557_(), originalInstance.m_19564_(), originalInstance.m_19571_(), false, originalInstance.m_19575_()));
        }
        if (!(pLivingEntity.m_9236_().f_46443_ || pLivingEntity.f_19797_ % 20 != 0 && pLivingEntity.f_19797_ % 18 != 0 && pLivingEntity.f_19797_ % 16 != 0)) {
            double offX = (pLivingEntity.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5;
            double offZ = (pLivingEntity.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5;
            CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)CoreParticles.STUNNED_PARTICLES.get(), pLivingEntity.m_20185_() + offX, pLivingEntity.m_20186_() + (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + offZ, 0.0, 0.0, 0.0), pLivingEntity);
        }
        if (pLivingEntity instanceof Player) {
            StunPlayerData data;
            Player player = (Player)pLivingEntity;
            if (!stunnedPlayers.containsKey(player.m_20148_())) {
                StunPlayerData data2 = new StunPlayerData(player.m_146908_(), player.m_146909_(), player.m_150110_().m_35947_(), player.m_150110_().m_35942_());
                stunnedPlayers.put(player.m_20148_(), data2);
                player.m_150110_().f_35938_ = false;
                player.m_150110_().f_35935_ = false;
                player.m_150110_().m_35948_(0.0f);
                if (!player.m_7500_()) {
                    player.m_150110_().m_35943_(0.0f);
                    player.m_150110_().f_35934_ = false;
                }
                player.m_150110_().m_35948_(data2.savedWalkingSpeed);
                player.m_150110_().m_35943_(data2.savedFlyingSpeed);
                player.m_6885_();
                player.m_6858_(false);
                player.m_6862_(false);
            }
            if ((data = stunnedPlayers.get(player.m_20148_())) != null) {
                player.m_146922_(data.savedYaw);
                player.m_146926_(data.savedPitch);
            }
            if (data != null) {
                player.m_146922_(data.savedYaw);
                player.m_146926_(data.savedPitch);
            }
            player.f_19864_ = true;
        } else if (pLivingEntity instanceof Mob) {
            Mob mob = (Mob)pLivingEntity;
            if (mob instanceof Creeper) {
                Creeper creeperMob = (Creeper)mob;
                creeperMob.m_32283_(-1);
            }
            mob.m_21557_(true);
            mob.f_19864_ = true;
            mob.m_6858_(false);
            mob.m_6862_(false);
            mob.m_21573_().m_26573_();
        }
        if (stunningPlayer != null && ModList.get().isLoaded("aspects")) {
            AspectsCompat.applyGlaciusTempestasSynergy((LivingEntity)stunningPlayer, pLivingEntity);
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        StunnedEffect.removeEntityStun(pLivingEntity);
        Player stunningPlayer = StunnedEffect.getStunner(pLivingEntity);
        if (stunningPlayer != null && ModList.get().isLoaded("aspects")) {
            AspectsCompat.applyTempestasUmbreSynergy((LivingEntity)stunningPlayer, pLivingEntity);
            AspectsCompat.applyTempestasArcaniInfernumSynergy((LivingEntity)stunningPlayer, pLivingEntity);
        }
    }

    private static Player getStunner(LivingEntity livingEntity) {
        Player stunningPlayer = null;
        if (livingEntity.getPersistentData().m_128403_("StunnedBy")) {
            stunningPlayer = livingEntity.m_9236_().m_46003_(livingEntity.getPersistentData().m_128342_("StunnedBy"));
        }
        return stunningPlayer;
    }

    public static void removeEntityStun(LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            stunnedPlayers.remove(player.m_20148_());
            player.m_150110_().f_35938_ = true;
            if (player.m_7500_()) {
                player.m_150110_().f_35934_ = true;
            }
            player.f_19864_ = true;
        } else if (pLivingEntity instanceof Mob) {
            Mob mob = (Mob)pLivingEntity;
            mob.m_21557_(false);
            mob.f_19864_ = true;
        }
        pLivingEntity.m_20334_(0.0, 0.0, 0.0);
    }

    public static class StunPlayerData {
        public final float savedYaw;
        public final float savedPitch;
        public final float savedWalkingSpeed;
        public final float savedFlyingSpeed;

        public StunPlayerData(float yaw, float pitch, float walkingSpeed, float flyingSpeed) {
            this.savedYaw = yaw;
            this.savedPitch = pitch;
            this.savedWalkingSpeed = walkingSpeed;
            this.savedFlyingSpeed = flyingSpeed;
        }
    }
}

