/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.effect.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.effects.SleepDataS2C;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;
import net.turtleboi.turtlecore.particle.CoreParticles;

public class SleepEffect
extends MobEffect {
    public static final Map<UUID, SleepPlayerData> sleptPlayers = new HashMap<UUID, SleepPlayerData>();

    public SleepEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        MobEffectInstance originalInstance;
        CoreNetworking.sendToAllPlayers(new SleepDataS2C(pLivingEntity.m_19879_(), true));
        if (pLivingEntity.m_21023_((MobEffect)CoreEffects.SLEEP.get()) && (originalInstance = pLivingEntity.m_21124_((MobEffect)CoreEffects.SLEEP.get())).m_19572_()) {
            originalInstance.m_19558_(new MobEffectInstance((MobEffect)CoreEffects.SLEEP.get(), originalInstance.m_19557_(), originalInstance.m_19564_(), originalInstance.m_19571_(), false, originalInstance.m_19575_()));
        }
        if (!(pLivingEntity.m_9236_().f_46443_ || pLivingEntity.f_19797_ % 20 != 0 && pLivingEntity.f_19797_ % 20 != 3 && pLivingEntity.f_19797_ % 20 != 6)) {
            Vec3 lookVector = pLivingEntity.m_20154_();
            double velocityX = lookVector.f_82479_ * 0.05 + 0.1;
            double velocityY = 0.1;
            double velocityZ = lookVector.f_82481_ * 0.05;
            double particleX = pLivingEntity.m_20185_();
            double particleY = pLivingEntity.m_20186_() + (double)pLivingEntity.m_20206_();
            double particleZ = pLivingEntity.m_20189_();
            if (pLivingEntity.f_19797_ % 20 == 0) {
                CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)CoreParticles.SLEEP_PARTICLE.get(), particleX, particleY, particleZ, velocityX * 1.5, velocityY * 1.5, velocityZ * 1.5), pLivingEntity);
            } else if (pLivingEntity.f_19797_ % 20 == 3) {
                CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)CoreParticles.SLEEP_PARTICLE.get(), particleX, particleY, particleZ, velocityX, velocityY, velocityZ), pLivingEntity);
            } else if (pLivingEntity.f_19797_ % 20 == 6) {
                CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)CoreParticles.SLEEP_PARTICLE.get(), particleX, particleY, particleZ, velocityX * 0.66, velocityY * 0.66, velocityZ * 0.66), pLivingEntity);
            }
        }
        if (pLivingEntity instanceof Player) {
            SleepPlayerData data;
            Player player = (Player)pLivingEntity;
            if (!sleptPlayers.containsKey(player.m_20148_())) {
                data = new SleepPlayerData(player.m_146908_(), player.m_146909_(), player.m_150110_().m_35947_(), player.m_150110_().m_35942_());
                sleptPlayers.put(player.m_20148_(), data);
                player.m_150110_().f_35938_ = false;
                player.m_150110_().f_35935_ = false;
                player.m_150110_().m_35948_(0.0f);
                if (!player.m_7500_()) {
                    player.m_150110_().m_35943_(0.0f);
                    player.m_150110_().f_35934_ = false;
                }
                player.m_150110_().m_35948_(data.savedWalkingSpeed);
                player.m_150110_().m_35943_(data.savedFlyingSpeed);
                player.m_6885_();
                player.m_6858_(false);
                player.m_6862_(false);
            }
            if ((data = sleptPlayers.get(player.m_20148_())) != null) {
                player.m_146922_(data.savedYaw);
                player.m_146926_(data.savedPitch);
            }
            if (data != null) {
                player.m_146922_(data.savedYaw);
                player.m_146926_(data.savedPitch);
            }
            player.f_19864_ = true;
        } else if (pLivingEntity instanceof Mob) {
            Mob mob = (Mob)pLivingEntity;
            if (mob instanceof Creeper) {
                Creeper creeperMob = (Creeper)mob;
                creeperMob.m_32283_(-1);
            }
            mob.m_21557_(true);
            mob.f_19864_ = true;
            mob.m_6858_(false);
            mob.m_6862_(false);
            mob.m_21573_().m_26573_();
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        SleepEffect.removeEntitySleep(pLivingEntity);
    }

    public static void removeEntitySleep(LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            sleptPlayers.remove(player.m_20148_());
            player.m_150110_().f_35938_ = true;
            if (player.m_7500_()) {
                player.m_150110_().f_35934_ = true;
            }
            player.f_19864_ = true;
        } else if (pLivingEntity instanceof Mob) {
            Mob mob = (Mob)pLivingEntity;
            mob.m_21557_(false);
            mob.f_19864_ = true;
        }
        pLivingEntity.m_20334_(0.0, 0.0, 0.0);
    }

    public static class SleepPlayerData {
        public final float savedYaw;
        public final float savedPitch;
        public final float savedWalkingSpeed;
        public final float savedFlyingSpeed;

        public SleepPlayerData(float yaw, float pitch, float walkingSpeed, float flyingSpeed) {
            this.savedYaw = yaw;
            this.savedPitch = pitch;
            this.savedWalkingSpeed = walkingSpeed;
            this.savedFlyingSpeed = flyingSpeed;
        }
    }
}

