/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.effect.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.init.CoreAttributeModifiers;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.effects.FrozenDataS2C;

public class FrozenEffect
extends MobEffect {
    private final String attributeModifierName = "frozen_movement_speed";
    public static final Map<UUID, FrozenPlayerData> frozenPlayers = new HashMap<UUID, FrozenPlayerData>();

    public FrozenEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        CoreNetworking.sendToAllPlayers(new FrozenDataS2C(pLivingEntity.m_19879_(), true));
        if (!pLivingEntity.m_9236_().m_5776_()) {
            if (pLivingEntity.m_21023_((MobEffect)CoreEffects.CHILLED.get())) {
                pLivingEntity.m_21195_((MobEffect)CoreEffects.CHILLED.get());
            }
            int duration = Objects.requireNonNull(pLivingEntity.m_21124_((MobEffect)CoreEffects.FROZEN.get())).m_19557_();
            if (!pLivingEntity.m_9236_().m_5776_() && duration > 2) {
                if (pLivingEntity instanceof Player) {
                    FrozenPlayerData data;
                    Player player = (Player)pLivingEntity;
                    if (!frozenPlayers.containsKey(player.m_20148_())) {
                        data = new FrozenPlayerData(player.m_150110_().m_35947_(), player.m_150110_().m_35942_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
                        frozenPlayers.put(player.m_20148_(), data);
                        player.m_150110_().f_35938_ = false;
                        player.m_150110_().m_35948_(0.0f);
                        if (!player.m_7500_()) {
                            player.m_150110_().m_35943_(0.0f);
                            player.m_150110_().f_35934_ = false;
                        }
                        player.m_150110_().m_35948_(data.savedWalkingSpeed);
                        player.m_150110_().m_35943_(data.savedFlyingSpeed);
                        player.m_6885_();
                        player.m_6858_(false);
                        player.m_6862_(false);
                    }
                    if ((data = frozenPlayers.get(player.m_20148_())) != null) {
                        player.m_6021_(data.savedX, data.savedY, data.savedZ);
                    }
                    player.f_19864_ = true;
                    CoreAttributeModifiers.applyPermanentModifier(pLivingEntity, Attributes.f_22279_, "frozen_movement_speed", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
                } else if (pLivingEntity instanceof Mob) {
                    Mob mob = (Mob)pLivingEntity;
                    Vec3 newVelocity = new Vec3(0.0, 0.0, 0.0);
                    mob.m_20256_(newVelocity);
                    mob.m_21557_(true);
                    mob.f_19864_ = true;
                    mob.m_6858_(false);
                    mob.m_6862_(false);
                    mob.m_21573_().m_26573_();
                }
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        CoreNetworking.sendToAllPlayers(new FrozenDataS2C(pLivingEntity.m_19879_(), false));
        FrozenEffect.removeEntityFreeze(pLivingEntity);
        CoreAttributeModifiers.removeModifier(pLivingEntity, Attributes.f_22279_, "frozen_movement_speed");
    }

    public static void removeEntityFreeze(LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            frozenPlayers.remove(player.m_20148_());
            player.m_150110_().f_35938_ = true;
            if (player.m_7500_()) {
                player.m_150110_().f_35934_ = true;
            }
            player.f_19864_ = true;
        } else if (pLivingEntity instanceof Mob) {
            Mob mob = (Mob)pLivingEntity;
            mob.m_21557_(false);
            mob.f_19864_ = true;
        }
        pLivingEntity.m_20334_(0.0, 0.0, 0.0);
    }

    public static class FrozenPlayerData {
        public final float savedWalkingSpeed;
        public final float savedFlyingSpeed;
        public final double savedX;
        public final double savedY;
        public final double savedZ;

        public FrozenPlayerData(float walkingSpeed, float flyingSpeed, double x, double y, double z) {
            this.savedWalkingSpeed = walkingSpeed;
            this.savedFlyingSpeed = flyingSpeed;
            this.savedX = x;
            this.savedY = y;
            this.savedZ = z;
        }
    }
}

