/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.effect.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.turtleboi.turtlecore.compat.aspects.AspectsCompat;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.init.CoreAttributeModifiers;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;
import net.turtleboi.turtlecore.particle.CoreParticles;

public class ChilledEffect
extends MobEffect {
    private final String attributeModifierName = "chilled_movement_speed";

    public ChilledEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        MobEffectInstance originalInstance;
        if (pLivingEntity.m_21023_((MobEffect)CoreEffects.CHILLED.get()) && (originalInstance = pLivingEntity.m_21124_((MobEffect)CoreEffects.CHILLED.get())).m_19572_()) {
            originalInstance.m_19558_(new MobEffectInstance((MobEffect)CoreEffects.CHILLED.get(), originalInstance.m_19557_(), originalInstance.m_19564_(), originalInstance.m_19571_(), false, originalInstance.m_19575_()));
        }
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 5 == 0) {
            for (int i = 0; i < (pAmplifier + 1) * 2; ++i) {
                double offX = (pLivingEntity.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5;
                double offY = (double)pLivingEntity.m_20206_() * pLivingEntity.m_9236_().f_46441_.m_188500_();
                double offZ = (pLivingEntity.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5;
                CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)CoreParticles.CHILLED_PARTICLES.get(), pLivingEntity.m_20185_() + offX, pLivingEntity.m_20186_() + offY, pLivingEntity.m_20189_() + offZ, 0.0, 0.0, 0.0), pLivingEntity);
            }
        }
        if (!pLivingEntity.m_9236_().m_5776_()) {
            if (pLivingEntity instanceof Mob) {
                Mob mob = (Mob)pLivingEntity;
                CoreAttributeModifiers.applyPermanentModifier((LivingEntity)mob, Attributes.f_22279_, "chilled_movement_speed", -0.125 * (double)(1 + pAmplifier), AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                CoreAttributeModifiers.applyPermanentModifier((LivingEntity)player, Attributes.f_22279_, "chilled_movement_speed", -0.2 * (double)(1 + pAmplifier), AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
            int freezeDuration = 100;
            Player chillingPlayer = ChilledEffect.getChiller(pLivingEntity);
            if (chillingPlayer != null && ModList.get().isLoaded("aspects")) {
                freezeDuration = AspectsCompat.getGlaciusFreezeDuration((LivingEntity)chillingPlayer, freezeDuration);
                AspectsCompat.applyGlaciusTerraSynergy((LivingEntity)chillingPlayer, pAmplifier);
            }
            if (pAmplifier > 3) {
                pLivingEntity.m_21195_((MobEffect)CoreEffects.CHILLED.get());
                pLivingEntity.m_7292_(new MobEffectInstance((MobEffect)CoreEffects.FROZEN.get(), freezeDuration, 0));
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        CoreAttributeModifiers.removeModifier(pLivingEntity, Attributes.f_22279_, "chilled_movement_speed");
    }

    private static Player getChiller(LivingEntity livingEntity) {
        Player chillingPlayer = null;
        if (livingEntity.getPersistentData().m_128403_("ChilledBy")) {
            chillingPlayer = livingEntity.m_9236_().m_46003_(livingEntity.getPersistentData().m_128342_("ChilledBy"));
        }
        return chillingPlayer;
    }
}

