/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.datagen;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.enchantment.CoreEnchantments;
import net.turtleboi.turtlecore.potion.CorePotions;

public class CoreLanguageProvider
extends LanguageProvider {
    protected final String modId;

    public CoreLanguageProvider(PackOutput output, String modId) {
        super(output, modId, "en_us");
        this.modId = modId;
    }

    protected void addTranslations() {
        this.addSimpleNameEnchant((Supplier<? extends Enchantment>)CoreEnchantments.SEEKING);
        this.addSimpleNameEnchant((Supplier<? extends Enchantment>)CoreEnchantments.RUPTURE);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.BLEEDING);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.ROOTED);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.CHILLED);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.FROZEN);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.STUNNED);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.VIGOR);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.SAPPED);
        this.addSimpleNameEffect((Supplier<? extends MobEffect>)CoreEffects.SLEEP);
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.CHILLING_POTION, "Chilling");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.CHILLING_POTION_2, "Chilling");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.FREEZING_POTION, "Freezing");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.STUNNING_POTION, "Stunning");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.VIGOR_POTION, "Vigor");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.VIGOR_POTION_2, "Vigor");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.SAPPING_POTION, "Sapping");
        this.addPotionTranslations((Supplier<? extends Potion>)CorePotions.SAPPING_POTION_2, "Sapping");
        this.addItemKey("when_thrown", "When Thrown:");
        this.addItemKey("throw_damage", "Thrown Damage");
        this.addAttributeKey("thrown_damage", "Thrown Damage");
        this.addDeathMessages("bleed", "%1$s bled out", "%1$s bled out due to %2$s");
    }

    public void addSimpleItemName(Supplier<? extends Item> supplier) {
        Item item = supplier.get();
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemId == null) {
            throw new IllegalStateException("Item not registered: " + item);
        }
        this.add(item, CoreLanguageProvider.toName(itemId.m_135815_()));
    }

    public void addSimpleNameBlock(Supplier<? extends Block> supplier) {
        Block block = supplier.get();
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId == null) {
            throw new IllegalStateException("Block not registered: " + block);
        }
        this.add(block, CoreLanguageProvider.toName(blockId.m_135815_()));
    }

    public void addSimpleNameEffect(Supplier<? extends MobEffect> supplier) {
        MobEffect effect = supplier.get();
        ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
        if (effectId == null) {
            throw new IllegalStateException("ModEffect not registered: " + effect);
        }
        this.add(effect, CoreLanguageProvider.toName(effectId.m_135815_()));
    }

    public void addSimpleNameEnchant(Supplier<? extends Enchantment> supplier) {
        Enchantment enchantment = supplier.get();
        ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (enchantmentId == null) {
            throw new IllegalStateException("Enchantment not registered: " + enchantment);
        }
        this.add(enchantment, CoreLanguageProvider.toName(enchantmentId.m_135815_()));
    }

    public void addPotionTranslations(Supplier<? extends Potion> potionSupplier, String baseName) {
        Potion potion = potionSupplier.get();
        ResourceLocation id = ForgeRegistries.POTIONS.getKey((Object)potion);
        if (id == null) {
            throw new IllegalStateException("Potion not registered: " + potion);
        }
        String path = id.m_135815_();
        this.add("item.minecraft.potion.effect." + path, "Potion of " + baseName);
        this.add("item.minecraft.splash_potion.effect." + path, "Splash Potion of " + baseName);
        this.add("item.minecraft.lingering_potion.effect." + path, "Lingering Potion of " + baseName);
    }

    public void addItemKey(String path, String value) {
        this.add("item." + this.modId + "." + path, value);
    }

    public void addAttributeKey(String path, String value) {
        this.add("attribute.name." + this.modId + "." + path, value);
    }

    public void addDeathMessages(String damageType, String base, String byKiller) {
        this.add("death.attack." + damageType, base);
        this.add("death.attack." + damageType + ".player", byKiller);
    }

    public static String toName(String registryPath) {
        StringBuilder stringBuilder = new StringBuilder(registryPath.length() + 8);
        for (String part : registryPath.split("_")) {
            if (part.isEmpty()) continue;
            stringBuilder.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() > 1) {
                stringBuilder.append(part.substring(1));
            }
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }
}

