/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.compat.aspects;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.turtleboi.turtlecore.effect.CoreEffects;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;
import net.turtleboi.turtlecore.util.EffectApplicationUtil;

public class AspectsCompat {
    public static double getInfernumAmplifier(LivingEntity livingEntity) {
        double infernumAmplifier = 0.0;
        Object aspect = AspectsCompat.getAspect("INFERNUM_ASPECT");
        Object attribute = AspectsCompat.invokeGet(aspect);
        if (livingEntity.m_21051_((Attribute)attribute) != null) {
            infernumAmplifier = livingEntity.m_21051_((Attribute)attribute).m_22135_();
        }
        return infernumAmplifier;
    }

    public static double getGlaciusAmplifier(LivingEntity livingEntity) {
        double glaciusAmplifier = 0.0;
        Object aspect = AspectsCompat.getAspect("GLACIUS_ASPECT");
        Object attribute = AspectsCompat.invokeGet(aspect);
        if (livingEntity.m_21051_((Attribute)attribute) != null) {
            glaciusAmplifier = livingEntity.m_21051_((Attribute)attribute).m_22135_();
        }
        return glaciusAmplifier;
    }

    public static double getTerraAmplifier(LivingEntity livingEntity) {
        double terraAmplifier = 0.0;
        Object aspect = AspectsCompat.getAspect("TERRA_ASPECT");
        Object attribute = AspectsCompat.invokeGet(aspect);
        if (livingEntity.m_21051_((Attribute)attribute) != null) {
            terraAmplifier = livingEntity.m_21051_((Attribute)attribute).m_22135_();
        }
        return terraAmplifier;
    }

    public static double getTempestasAmplifier(LivingEntity livingEntity) {
        double tempestasAmplifier = 0.0;
        Object aspect = AspectsCompat.getAspect("TEMPESTAS_ASPECT");
        Object attribute = AspectsCompat.invokeGet(aspect);
        if (livingEntity.m_21051_((Attribute)attribute) != null) {
            tempestasAmplifier = livingEntity.m_21051_((Attribute)attribute).m_22135_();
        }
        return tempestasAmplifier;
    }

    public static double getArcaniAmplifier(LivingEntity livingEntity) {
        double arcaniAmplifier = 0.0;
        Object aspect = AspectsCompat.getAspect("ARCANI_ASPECT");
        Object attribute = AspectsCompat.invokeGet(aspect);
        if (livingEntity.m_21051_((Attribute)attribute) != null) {
            arcaniAmplifier = livingEntity.m_21051_((Attribute)attribute).m_22135_();
        }
        return arcaniAmplifier;
    }

    public static double getArcaniFactor(LivingEntity livingEntity) {
        double arcaniAmplifier = AspectsCompat.getArcaniAmplifier(livingEntity);
        return 1.0 + arcaniAmplifier / 4.0;
    }

    public static double getUmbreAmplifier(LivingEntity livingEntity) {
        double umbreAmplifier = 0.0;
        Object aspect = AspectsCompat.getAspect("UMBRE_ASPECT");
        Object attribute = AspectsCompat.invokeGet(aspect);
        if (livingEntity.m_21051_((Attribute)attribute) != null) {
            umbreAmplifier = livingEntity.m_21051_((Attribute)attribute).m_22135_();
        }
        return umbreAmplifier;
    }

    public static int getGlaciusFreezeDuration(LivingEntity chillerEntity, int freezeDuration) {
        double arcaniFactor = AspectsCompat.getArcaniFactor(chillerEntity);
        return (int)((double)freezeDuration * arcaniFactor);
    }

    public static void applyGlaciusTerraSynergy(LivingEntity chillerEntity, int pAmplifier) {
        double arcaniFactor = AspectsCompat.getArcaniFactor(chillerEntity);
        double terraAmplifier = AspectsCompat.getTerraAmplifier(chillerEntity);
        if (terraAmplifier > 0.0) {
            if (!chillerEntity.m_21023_(MobEffects.f_19606_)) {
                chillerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, (int)(600.0 * terraAmplifier * arcaniFactor), pAmplifier, false, true, true));
            } else if (chillerEntity.m_21023_(MobEffects.f_19606_) && chillerEntity.m_21124_(MobEffects.f_19606_).m_19564_() <= pAmplifier) {
                chillerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, (int)(600.0 * terraAmplifier * arcaniFactor), pAmplifier, false, true, true));
            }
        }
    }

    public static void applyGlaciusTempestasSynergy(LivingEntity stunningPlayer, LivingEntity stunnedEntity) {
        double arcaniFactor = AspectsCompat.getArcaniFactor(stunningPlayer);
        double glaciusAmplifier = AspectsCompat.getGlaciusAmplifier(stunningPlayer);
        if (glaciusAmplifier > 0.0 && stunnedEntity.f_19797_ % 20 == 0) {
            AspectsCompat.addColdAuraForEntity((Entity)stunnedEntity, 30, (int)glaciusAmplifier);
            stunnedEntity.m_9236_().m_6263_(null, stunnedEntity.m_20185_(), stunnedEntity.m_20186_(), stunnedEntity.m_20189_(), SoundEvents.f_144205_, SoundSource.HOSTILE, 1.0f, 0.4f / (stunnedEntity.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            RandomSource random = stunnedEntity.m_9236_().m_213780_();
            int count = (int)((glaciusAmplifier + 1.0) * 20.0);
            for (int i = 0; i < count; ++i) {
                double theta = random.m_188500_() * Math.PI;
                double phi = random.m_188500_() * 2.0 * Math.PI;
                double speed = 0.2 + random.m_188500_() * 0.3;
                double xSpeed = speed * Math.sin(theta) * Math.cos(phi);
                double ySpeed = speed * Math.cos(theta);
                double zSpeed = speed * Math.sin(theta) * Math.sin(phi);
                double offX = (random.m_188500_() - 0.5) * 0.2;
                double offY = stunnedEntity.m_20206_() / 2.0f;
                double offZ = (random.m_188500_() - 0.5) * 0.2;
                CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)ParticleTypes.f_175821_, stunnedEntity.m_20185_() + offX, stunnedEntity.m_20186_() + offY, stunnedEntity.m_20189_() + offZ, xSpeed, ySpeed, zSpeed), stunnedEntity);
            }
            AABB ignitionArea = new AABB(stunnedEntity.m_20185_() - 2.0, stunnedEntity.m_20186_() - 2.0, stunnedEntity.m_20189_() - 2.0, stunnedEntity.m_20185_() + 2.0, stunnedEntity.m_20186_() + 2.0, stunnedEntity.m_20189_() + 2.0);
            List chilledEntities = stunnedEntity.m_9236_().m_6443_(LivingEntity.class, ignitionArea, e -> e != stunnedEntity && !(e instanceof Player));
            for (LivingEntity chilledEntity : chilledEntities) {
                EffectApplicationUtil.setChiller(chilledEntity, (Entity)stunningPlayer);
                int chillTicks = (int)(40.0 * glaciusAmplifier * arcaniFactor);
                chilledEntity.m_7292_(new MobEffectInstance((MobEffect)CoreEffects.CHILLED.get(), chillTicks, (int)glaciusAmplifier - 1));
            }
        }
    }

    public static void applyTempestasUmbreSynergy(LivingEntity stunningPlayer, LivingEntity stunnedEntity) {
        if (AspectsCompat.getUmbreAmplifier(stunningPlayer) > 0.0) {
            try {
                Class<?> singularityEntityClass = Class.forName("net.turtleboi.aspects.entity.entities.SingularityEntity");
                Class<?> modEntitiesClass = Class.forName("net.turtleboi.aspects.entity.ModEntities");
                Field singularityField = modEntitiesClass.getField("SINGULARITY");
                Object registryObj = singularityField.get(null);
                Method getMethod = registryObj.getClass().getMethod("get", new Class[0]);
                Object singularityEntityType = getMethod.invoke(registryObj, new Object[0]);
                Class<?> entityTypeClass = Class.forName("net.minecraft.world.entity.EntityType");
                Class<?> levelClass = Class.forName("net.minecraft.world.level.Level");
                Constructor<?> constructor = singularityEntityClass.getConstructor(entityTypeClass, levelClass);
                Object blackHole = constructor.newInstance(singularityEntityType, stunnedEntity.m_9236_());
                Method setOwnerMethod = singularityEntityClass.getMethod("setOwner", LivingEntity.class);
                setOwnerMethod.invoke(blackHole, stunnedEntity);
                Method setPosMethod = singularityEntityClass.getMethod("setPos", Double.TYPE, Double.TYPE, Double.TYPE);
                double x = stunnedEntity.m_20185_();
                double y = stunnedEntity.m_20186_() + (double)stunnedEntity.m_20206_();
                double z = stunnedEntity.m_20189_();
                setPosMethod.invoke(blackHole, x, y, z);
                stunnedEntity.m_9236_().m_7967_((Entity)blackHole);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void applyTempestasArcaniInfernumSynergy(LivingEntity stunningPlayer, LivingEntity stunnedEntity) {
        Level level;
        double arcaniAmplifier = AspectsCompat.getArcaniAmplifier(stunningPlayer);
        double infernumAmplifier = AspectsCompat.getInfernumAmplifier(stunningPlayer);
        if (AspectsCompat.getArcaniAmplifier(stunningPlayer) > 0.0 && (level = stunnedEntity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = 0;
            while ((double)i < arcaniAmplifier / 2.0) {
                LightningBolt lightning = new LightningBolt(EntityType.f_20465_, (Level)serverLevel);
                lightning.m_6034_(stunnedEntity.m_20185_(), stunnedEntity.m_20186_(), stunnedEntity.m_20189_());
                serverLevel.m_7967_((Entity)lightning);
                ++i;
            }
            if (infernumAmplifier > 0.0) {
                AABB ignitionArea = new AABB(stunnedEntity.m_20185_() - 2.0, stunnedEntity.m_20186_() - 2.0, stunnedEntity.m_20189_() - 2.0, stunnedEntity.m_20185_() + 2.0, stunnedEntity.m_20186_() + 2.0, stunnedEntity.m_20189_() + 2.0);
                List ignitedEntities = stunnedEntity.m_9236_().m_6443_(LivingEntity.class, ignitionArea, e -> e != stunnedEntity && !(e instanceof Player));
                for (LivingEntity ignitedEntity : ignitedEntities) {
                    EffectApplicationUtil.setIgnitor(ignitedEntity, (Entity)stunningPlayer);
                }
            }
        }
    }

    private static Object getAspect(String aspectFieldName) {
        try {
            Class<?> modAttributesClass = Class.forName("net.turtleboi.aspects.util.ModAttributes");
            Field field = modAttributesClass.getField(aspectFieldName);
            return field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getEntity(String entityFieldName) {
        try {
            Class<?> modEntitiesClass = Class.forName("net.turtleboi.aspects.entity.ModEntities");
            Field field = modEntitiesClass.getField(entityFieldName);
            return field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void addColdAuraForEntity(Entity stunnedEntity, int auraTicks, double glaciusAmplifier) {
        try {
            Class<?> rendererClass = Class.forName("net.turtleboi.aspects.client.renderer.ColdAuraRenderer");
            Method addAuraMethod = rendererClass.getMethod("addAuraForEntity", Entity.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
            addAuraMethod.invoke(null, stunnedEntity, System.currentTimeMillis(), auraTicks, (int)glaciusAmplifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object invokeGet(Object getObject) {
        try {
            Method getMethod = getObject.getClass().getMethod("get", new Class[0]);
            return getMethod.invoke(getObject, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

