/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.turtleboi.turtlecore.client.data.TargetingClientData;
import net.turtleboi.turtlecore.client.util.VertexBuilder;
import net.turtleboi.turtlecore.config.TurtleCoreConfig;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TargetArrowRenderer {
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("turtlecore", "textures/gui/target_arrow.png");
    private static final ResourceLocation LOCKED_ARROW_TEXTURE = new ResourceLocation("turtlecore", "textures/gui/target_arrow_locked.png");

    public static void renderTargetArrow(PoseStack poseStack, MultiBufferSource bufferSource, Minecraft minecraft, Entity target, Player player) {
        if ((((Boolean)TurtleCoreConfig.TARGETTING_ARROW_TOGGLE.get()).booleanValue() || TargetingClientData.isLockedOn()) && target != null && player != null) {
            int g;
            int r;
            RenderSystem.setShader(GameRenderer::m_172817_);
            ResourceLocation arrowTexture = TargetingClientData.isLockedOn() ? LOCKED_ARROW_TEXTURE : ARROW_TEXTURE;
            RenderType renderType = RenderType.m_234338_((ResourceLocation)arrowTexture);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)arrowTexture);
            if (target instanceof Monster || target instanceof FlyingMob || target instanceof EnderDragon || target instanceof Shulker || target instanceof Slime || target instanceof ZombieHorse || target instanceof SkeletonHorse || target instanceof Hoglin) {
                r = 255;
                g = 40;
            } else {
                r = 188;
                g = 255;
            }
            int b = 0;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, target.m_20206_() + target.m_20206_() / 3.0f, 0.0f);
            poseStack.m_252781_(minecraft.m_91290_().m_253208_());
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f matrix = pose.m_252922_();
            Matrix3f normalMatrix = pose.m_252943_();
            VertexBuilder.vertex(vertexConsumer, matrix, normalMatrix, -0.33f, -0.33f, 0.0f, 0.0f, 1.0f, r, g, b, 255);
            VertexBuilder.vertex(vertexConsumer, matrix, normalMatrix, -0.33f, 0.33f, 0.0f, 0.0f, 0.0f, r, g, b, 255);
            VertexBuilder.vertex(vertexConsumer, matrix, normalMatrix, 0.33f, 0.33f, 0.0f, 1.0f, 0.0f, r, g, b, 255);
            VertexBuilder.vertex(vertexConsumer, matrix, normalMatrix, 0.33f, -0.33f, 0.0f, 1.0f, 1.0f, r, g, b, 255);
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

