/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.client.renderer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.turtleboi.turtlecore.client.util.ParticleSpawnQueue;
import net.turtleboi.turtlecore.network.CoreNetworking;
import net.turtleboi.turtlecore.network.packet.util.SendParticlesS2C;

public class ShockwaveRenderer {
    private final long startTime;
    private final int durationTicks;

    public ShockwaveRenderer(long currentTime, int durationTicks) {
        this.startTime = currentTime;
        this.durationTicks = durationTicks;
    }

    public boolean isFinished() {
        long elapsedMillis = System.currentTimeMillis() - this.startTime;
        return elapsedMillis > (long)this.durationTicks * 50L;
    }

    public static void triggerShockwave(LivingEntity entity, int radius) {
        Level world = entity.m_9236_();
        BlockPos center = entity.m_20183_().m_7495_();
        RandomSource random = world.m_213780_();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos pos;
                BlockState state;
                if (dx * dx + dz * dz > radius * radius || (state = world.m_8055_(pos = center.m_7918_(dx, 0, dz))).m_60795_() || state.m_60734_() == Blocks.f_49990_) continue;
                for (int i = 0; i < 40; ++i) {
                    double offsetZ;
                    double spawnX = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5);
                    double spawnY = (double)(pos.m_123342_() + 1) + random.m_188500_() * 0.3;
                    double spawnZ = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5);
                    double offsetX = (double)pos.m_123341_() + 0.5 - entity.m_20185_();
                    double distance = Mth.m_14116_((float)((float)(offsetX * offsetX + (offsetZ = (double)pos.m_123343_() + 0.5 - entity.m_20189_()) * offsetZ)));
                    double normX = distance != 0.0 ? offsetX / distance : 0.0;
                    double normZ = distance != 0.0 ? offsetZ / distance : 0.0;
                    double velocityX = normX * (0.1 + random.m_188500_() * 0.1);
                    double velocityY = 0.5 + random.m_188500_() * 0.5;
                    double velocityZ = normZ * (0.1 + random.m_188500_() * 0.1);
                    long delayTicks = (long)distance;
                    long delayMillis = delayTicks * 50L;
                    ParticleSpawnQueue.schedule(delayMillis, () -> CoreNetworking.sendToNear(new SendParticlesS2C((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), spawnX, spawnY, spawnZ, velocityX, velocityY, velocityZ), entity));
                }
            }
        }
    }
}

