/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.client.data;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;

public class SpikeData {
    public final float width;
    public final float height;
    public final ResourceLocation texture;
    public final float zTranslationOffset;
    public final float xAngleOffset;
    public final float yAngleOffset;
    public final float zAngleOffset;

    public SpikeData(float width, float height, ResourceLocation texture, float zTranslationOffset, float xAngleOffset, float yAngleOffset, float zAngleOffset) {
        this.width = width;
        this.height = height;
        this.texture = texture;
        this.zTranslationOffset = zTranslationOffset;
        this.xAngleOffset = xAngleOffset;
        this.yAngleOffset = yAngleOffset;
        this.zAngleOffset = zAngleOffset;
    }

    public SpikeData(float width, float height, ResourceLocation texture, Random random) {
        this.width = width;
        this.height = height;
        this.texture = texture;
        this.zTranslationOffset = random.nextFloat();
        this.xAngleOffset = random.nextFloat() * 60.0f - 30.0f;
        this.yAngleOffset = random.nextFloat() * 10.0f - 5.0f;
        this.zAngleOffset = random.nextFloat() * 30.0f - 15.0f;
    }

    public static SpikeData[] createPremadeSpikes(Random random) {
        return new SpikeData[]{new SpikeData(5.0f, 8.0f, new ResourceLocation("turtlecore", "textures/spell_effects/ice_spikes/spike1.png"), random), new SpikeData(8.0f, 11.0f, new ResourceLocation("turtlecore", "textures/spell_effects/ice_spikes/spike2.png"), random), new SpikeData(8.0f, 14.0f, new ResourceLocation("turtlecore", "textures/spell_effects/ice_spikes/spike3.png"), random), new SpikeData(6.0f, 11.0f, new ResourceLocation("turtlecore", "textures/spell_effects/ice_spikes/spike4.png"), random), new SpikeData(6.0f, 19.0f, new ResourceLocation("turtlecore", "textures/spell_effects/ice_spikes/spike5.png"), random), new SpikeData(8.0f, 8.0f, new ResourceLocation("turtlecore", "textures/spell_effects/ice_spikes/spike6.png"), random)};
    }

    public static SpikeData[] getPremadeSpikesByIds(Random random, int ... ids) {
        SpikeData[] allSpikes = SpikeData.createPremadeSpikes(random);
        ArrayList<SpikeData> selected = new ArrayList<SpikeData>();
        for (int id : ids) {
            if (id < 1 || id > allSpikes.length) continue;
            selected.add(allSpikes[id - 1]);
        }
        return selected.toArray(new SpikeData[0]);
    }
}

