/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.capabilities.targeting;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class PlayerTargetingData {
    private LivingEntity lockedTarget;
    private boolean isLockedOn;

    public LivingEntity getLockedTarget() {
        return this.lockedTarget;
    }

    public void setLockedTarget(LivingEntity target) {
        this.lockedTarget = target;
    }

    public void setLockedOn(boolean lockedOn) {
        this.isLockedOn = lockedOn;
    }

    public boolean isLockedOn() {
        return this.isLockedOn;
    }

    public void copyFrom(PlayerTargetingData source) {
        this.lockedTarget = source.lockedTarget;
        this.isLockedOn = source.isLockedOn;
    }

    public void saveNBTData(CompoundTag nbt) {
        if (this.lockedTarget != null) {
            nbt.m_128362_("lockedTargetUUID", this.lockedTarget.m_20148_());
        }
        nbt.m_128379_("isLockedOn", this.isLockedOn);
    }

    public void loadNBTData(CompoundTag nbt, Player player) {
        this.isLockedOn = nbt.m_128471_("isLockedOn");
        if (nbt.m_128441_("lockedTargetUUID")) {
            UUID uuid = nbt.m_128342_("lockedTargetUUID");
            this.lockedTarget = this.findEntityByUUID(uuid, player);
        } else {
            this.lockedTarget = null;
        }
    }

    private LivingEntity findEntityByUUID(UUID uuid, Player player) {
        return player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(25.0)).stream().filter(entity -> entity.m_20148_().equals(uuid)).findFirst().orElse(null);
    }
}

