/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.turtlecore.capabilities.party;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class PlayerParty {
    private final Set<UUID> partyMembers = new HashSet<UUID>();

    public Set<UUID> getPartyMembers() {
        return this.partyMembers;
    }

    public void addMember(UUID member) {
        this.partyMembers.add(member);
    }

    public void removeMember(UUID member) {
        this.partyMembers.remove(member);
    }

    public boolean isMember(UUID uuid) {
        return this.partyMembers.contains(uuid);
    }

    public void copyFrom(PlayerParty source) {
        this.partyMembers.clear();
        this.partyMembers.addAll(source.partyMembers);
    }

    public void saveNBTData(CompoundTag nbt) {
        ListTag listTag = new ListTag();
        for (UUID uuid : this.partyMembers) {
            CompoundTag memberTag = new CompoundTag();
            memberTag.m_128362_("uuid", uuid);
            listTag.add((Object)memberTag);
        }
        nbt.m_128365_("partyMembers", (Tag)listTag);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.partyMembers.clear();
        ListTag listTag = nbt.m_128437_("partyMembers", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag memberTag = listTag.m_128728_(i);
            UUID uuid = memberTag.m_128342_("uuid");
            this.partyMembers.add(uuid);
        }
    }
}

