/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.agreement.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.RandomSource;

public record SteppedInt(int min, int max, int step) {
    public static final Codec<SteppedInt> CODEC = SteppedInt.codec();

    public SteppedInt(int min, int max) {
        this(min, max, 1);
    }

    private static Codec<SteppedInt> codec() {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(SteppedInt::min), (App)Codec.INT.fieldOf("max").forGetter(SteppedInt::max), (App)Codec.INT.optionalFieldOf("step", (Object)1).forGetter(SteppedInt::step)).apply((Applicative)instance, SteppedInt::new));
        Function<SteppedInt, DataResult> validateFunc = steppedInt -> {
            if (steppedInt.max < steppedInt.min) {
                return DataResult.error(() -> "'max' should be larger than 'min'. '" + steppedInt + "'.");
            }
            return DataResult.success((Object)steppedInt);
        };
        return codec.flatXmap(validateFunc, validateFunc);
    }

    public int sample(RandomSource random) {
        int sample = random.m_216339_(this.min, this.max + 1);
        int offset = Math.abs(sample % this.step);
        return offset != 0 ? Math.min(this.max, sample - offset + Math.abs(this.step)) : sample;
    }
}

