/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.agreement.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.wares.data.agreement.component.CompoundTagCompareBehavior;
import io.github.mortuusars.wares.data.agreement.component.SteppedInt;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SealedRequestedItem {
    public static final Codec<SealedRequestedItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)TagKey.m_203886_((ResourceKey)Registries.f_256913_), (Codec)ForgeRegistries.ITEMS.getCodec()).fieldOf("id").forGetter(SealedRequestedItem::getTagOrItem), (App)Codec.either((Codec)ExtraCodecs.f_144629_, SteppedInt.CODEC).optionalFieldOf("Count", (Object)Either.left((Object)1)).forGetter(SealedRequestedItem::getCount), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(sri -> Optional.ofNullable(sri.getTag())), (App)StringRepresentable.m_216439_(CompoundTagCompareBehavior::values).optionalFieldOf("TagMatching", (Object)CompoundTagCompareBehavior.WEAK).forGetter(SealedRequestedItem::getTagCompareBehavior)).apply((Applicative)instance, SealedRequestedItem::new));
    public static final SealedRequestedItem EMPTY = new SealedRequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_41852_), (Either<Integer, SteppedInt>)Either.left((Object)1), (CompoundTag)null, CompoundTagCompareBehavior.WEAK);
    private final Either<TagKey<Item>, Item> tagOrItem;
    private final Either<Integer, SteppedInt> count;
    @Nullable
    private final CompoundTag tag;
    private final CompoundTagCompareBehavior tagCompareBehavior;

    public SealedRequestedItem(Either<TagKey<Item>, Item> tagOrItem, Either<Integer, SteppedInt> count, @Nullable CompoundTag tag, CompoundTagCompareBehavior tagCompareBehavior) {
        this.tagOrItem = tagOrItem;
        this.count = count;
        this.tag = tag;
        this.tagCompareBehavior = tagCompareBehavior;
    }

    private SealedRequestedItem(Either<TagKey<Item>, Item> tagOrItem, Either<Integer, SteppedInt> count, Optional<CompoundTag> tag, CompoundTagCompareBehavior tagCompareBehavior) {
        this(tagOrItem, count, (CompoundTag)tag.orElse(null), tagCompareBehavior);
    }

    public Either<TagKey<Item>, Item> getTagOrItem() {
        return this.tagOrItem;
    }

    public Either<Integer, SteppedInt> getCount() {
        return this.count;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public CompoundTagCompareBehavior getTagCompareBehavior() {
        return this.tagCompareBehavior;
    }

    public String toString() {
        return "RequestedItem{tagOrItem=" + (String)this.tagOrItem.map(tag -> "#" + tag.f_203868_(), item -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).toString()) + ", count=" + (String)this.count.map(integer -> Integer.toString(integer), steppedInt -> String.format("SteppedInt{%s,%s,%s}", steppedInt.min(), steppedInt.max(), steppedInt.step())) + (String)(this.tag != null ? ", tag=" + this.tag : "") + ",TagMatching:" + this.tagCompareBehavior.m_7912_() + "}";
    }
}

