/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hardernaturalhealing.forgeevents;

import com.mactso.hardernaturalhealing.config.MyConfig;
import com.mactso.hardernaturalhealing.utility.Utility;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerTickHandler {
    @SubscribeEvent
    public static void playerTickHandler(TickEvent.PlayerTickEvent event) {
        if (event.player.m_20193_() instanceof ServerLevel) {
            int nextHealingTime;
            int sessionGameTime;
            Player p = event.player;
            Level w = p.m_9236_();
            long gameTime = w.m_46467_();
            if (p.m_21224_() || event.phase == TickEvent.Phase.END || gameTime % 20L != 0L || p.m_21223_() >= p.m_21233_()) {
                return;
            }
            Utility.debugMsg(1, "Handling Player " + p.m_7755_().getString() + ".  Player is wounded.");
            if (MyConfig.getExtraExhaustionWhenHurt() > 0.0) {
                p.m_36324_().m_38703_((float)MyConfig.getExtraExhaustionWhenHurt());
            }
            Difficulty dif = p.m_9236_().m_46791_();
            boolean handleStarving = false;
            if (p.m_36324_().m_38702_() <= 0) {
                handleStarving = true;
                if (dif == Difficulty.HARD) {
                    handleStarving = false;
                }
                if (dif == Difficulty.NORMAL && (double)p.m_21223_() > 1.0) {
                    handleStarving = false;
                }
                if (dif == Difficulty.EASY && (double)p.m_21223_() > 10.0) {
                    handleStarving = false;
                }
            }
            if (handleStarving && gameTime % 80L == 0L && p.m_21223_() > (float)MyConfig.getMinimumStarvationHealth()) {
                p.m_6469_(p.m_269291_().m_269064_(), 1.0f);
            }
            if ((sessionGameTime = p.f_19797_) < (nextHealingTime = p.m_21215_() + MyConfig.getAttackHealingDelayTicks())) {
                return;
            }
            if ((double)p.m_36324_().m_38702_() < MyConfig.getMinimumFoodHealingLevel()) {
                return;
            }
            if (MyConfig.getHealingPerSecond() > 0.0) {
                p.m_5634_((float)MyConfig.getHealingPerSecond());
                p.m_36324_().m_38703_((float)MyConfig.getHealingExhaustionCost());
            }
        }
    }
}

