/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.jeitetra.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ToolAction;
import net.yiran.jeitetra.util.GuiBaseInfo;
import net.yiran.jeitetra.util.GuiEffectRecipe;
import net.yiran.jeitetra.util.GuiMultiInfo;
import net.yiran.jeitetra.util.ModuleData;
import org.joml.Vector4f;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.VariantData;

public class GuiCustomData
extends GuiElement {
    public int offsetY = 0;

    public GuiCustomData(int x, int y, int width, int height, MaterialData materialData) {
        super(x, y, width, height);
        EffectData effects;
        Set effectSet;
        this.addChild(new GuiBaseInfo(5, "durability", Float.valueOf(materialData.durability)));
        this.addChild(new GuiBaseInfo(5, "primary", materialData.primary));
        this.addChild(new GuiBaseInfo(5, "secondary", materialData.secondary));
        this.addChild(new GuiBaseInfo(5, "tertiary", materialData.tertiary));
        this.addChild(new GuiBaseInfo(5, "toolLevel", materialData.toolLevel));
        this.addChild(new GuiBaseInfo(5, "toolEfficiency", Float.valueOf(materialData.toolEfficiency)));
        this.addChild(new GuiBaseInfo(5, "experienceCost", Float.valueOf(materialData.experienceCost)));
        this.addChild(new GuiBaseInfo(5, "integrityGain", Float.valueOf(materialData.integrityGain)));
        this.addChild(new GuiBaseInfo(5, "integrityCost", Float.valueOf(materialData.integrityCost)));
        if (materialData.requiredTools != null) {
            this.addChild(new GuiMultiInfo(5, "requiredTools", materialData.requiredTools.levelMap.entrySet().stream().collect(Collectors.toMap(e -> I18n.m_118938_((String)("tetra.tool." + ((ToolAction)e.getKey()).name()), (Object[])new Object[0]), e -> ((Float)e.getValue()).toString()))));
        }
        if (materialData.attributes != null) {
            HashMultimap multimap = HashMultimap.create();
            materialData.attributes.entries().stream().forEach(arg_0 -> this.lambda$new$2((Multimap)multimap, arg_0));
            this.addChild(new GuiMultiInfo(5, "attributes", (Multimap<String, String>)multimap));
        }
        if (!(effectSet = (effects = materialData.effects).getValues()).isEmpty()) {
            this.addChild((GuiElement)new GuiString(5, 0, I18n.m_118938_((String)"tetra.holo.craft.materials.stat.effects", (Object[])new Object[0])));
            effectSet.forEach(itemEffect -> this.addChild((GuiElement)new GuiEffectRecipe(10, this.getNumChildren() * 10, (ItemEffect)itemEffect, effects.getLevel(itemEffect), effects.getEfficiency(itemEffect))));
        }
        if (!materialData.aspects.levelMap.isEmpty()) {
            this.addChild(new GuiMultiInfo(5, "aspects", materialData.aspects.levelMap.entrySet().stream().collect(Collectors.toMap(e -> I18n.m_118938_((String)("tetra.aspect." + ((ItemAspect)e.getKey()).getKey()), (Object[])new Object[0]), e -> String.valueOf(((Float)e.getValue()).intValue())))));
        }
        if (!materialData.improvements.isEmpty()) {
            this.addChild(new GuiMultiInfo(5, "improvements", materialData.improvements.entrySet().stream().collect(Collectors.toMap(e -> I18n.m_118938_((String)("tetra.improvement." + (String)e.getKey() + ".name"), (Object[])new Object[0]), e -> ((Integer)e.getValue()).toString()))));
        }
    }

    public GuiCustomData(int x, int y, int width, int height, ModuleData materialData) {
        super(x, y, width, height);
        Set effectSet;
        EffectData effects;
        VariantData variantData = materialData.variantData();
        this.addChild(new GuiBaseInfo(5, "durability", variantData.durability));
        this.addChild(new GuiBaseInfo(5, "magicCapacity", variantData.magicCapacity));
        this.addChild(new GuiBaseInfo(5, "integrity", variantData.integrity));
        if (variantData.tools != null) {
            this.addChild(new GuiMultiInfo(5, "hasTools", variantData.tools.getValues().stream().collect(Collectors.toMap(t -> I18n.m_118938_((String)("tetra.tool." + t.name()), (Object[])new Object[0]), t -> " [ " + variantData.tools.getLevel(t) + " , " + variantData.tools.getEfficiency(t) + " ]"))));
        }
        if (variantData.attributes != null) {
            HashMultimap multimap = HashMultimap.create();
            variantData.attributes.entries().stream().forEach(arg_0 -> this.lambda$new$10((Multimap)multimap, arg_0));
            this.addChild(new GuiMultiInfo(5, "attributesT", (Multimap<String, String>)multimap));
        }
        if ((effects = variantData.effects) != null && !(effectSet = effects.getValues()).isEmpty()) {
            this.addChild((GuiElement)new GuiString(5, 0, I18n.m_118938_((String)"tetra.holo.craft.materials.stat.effectsT", (Object[])new Object[0])));
            effectSet.forEach(itemEffect -> this.addChild((GuiElement)new GuiEffectRecipe(10, this.getNumChildren() * 10, (ItemEffect)itemEffect, effects.getLevel(itemEffect), effects.getEfficiency(itemEffect))));
        }
        if (variantData.aspects != null && !variantData.aspects.levelMap.isEmpty()) {
            this.addChild(new GuiMultiInfo(5, "aspectsT", variantData.aspects.levelMap.entrySet().stream().collect(Collectors.toMap(e -> I18n.m_118938_((String)("tetra.aspect." + ((ItemAspect)e.getKey()).getKey()), (Object[])new Object[0]), e -> String.valueOf(((Float)e.getValue()).intValue())))));
        }
    }

    public String getAttributeModifierValue(AttributeModifier modifier) {
        String color;
        String string = color = modifier.m_22218_() > 0.0 ? "\u00a7a" : "\u00a74";
        if (modifier.m_22217_().m_22235_() == 0) {
            return color + modifier.m_22218_();
        }
        return color + modifier.m_22218_() * 100.0 + "%";
    }

    public int getChildButton() {
        if (this.getNumChildren() != 0) {
            GuiElement lastChild = this.getChild(this.getNumChildren() - 1);
            return lastChild.getHeight() + lastChild.getY();
        }
        return 0;
    }

    public void addChild(GuiElement child) {
        if (child.shouldRemove()) {
            return;
        }
        child.setY(this.getChildButton());
        super.addChild(child);
    }

    public void draw(GuiGraphics graphics, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        Vector4f pos = graphics.m_280168_().m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        graphics.m_280588_((int)pos.x + this.x, (int)pos.y + this.y, (int)pos.x + this.x + this.width, (int)pos.y + this.y + this.height);
        super.draw(graphics, refX, refY + Mth.m_14045_((int)this.offsetY, (int)(-this.getChildButton()), (int)0), screenWidth, screenHeight, mouseX, mouseY, opacity);
        graphics.m_280618_();
    }

    public void updateFocusState(int refX, int refY, int mouseX, int mouseY) {
        if (this.mouseOutScreen(refX + mouseX, refY + mouseY)) {
            super.updateFocusState(-9999, -9999, -9999, -9999);
            return;
        }
        super.updateFocusState(refX, refY + this.offsetY, mouseX, mouseY);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double distance) {
        if (this.mouseOutScreen((int)mouseX, (int)mouseY)) {
            return false;
        }
        if ((double)this.offsetY + distance * 3.0 < (double)(-this.getChildButton() + this.height) || (double)this.offsetY + distance * 3.0 > 0.0) {
            return false;
        }
        this.offsetY += (int)distance * 6;
        return true;
    }

    public boolean mouseOutScreen(int mouseX, int mouseY) {
        return mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height;
    }

    private /* synthetic */ void lambda$new$10(Multimap multimap, Map.Entry e) {
        multimap.put((Object)I18n.m_118938_((String)((Attribute)e.getKey()).m_22087_(), (Object[])new Object[0]), (Object)this.getAttributeModifierValue((AttributeModifier)e.getValue()));
    }

    private /* synthetic */ void lambda$new$2(Multimap multimap, Map.Entry e) {
        multimap.put((Object)I18n.m_118938_((String)((Attribute)e.getKey()).m_22087_(), (Object[])new Object[0]), (Object)this.getAttributeModifierValue((AttributeModifier)e.getValue()));
    }
}

