/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.jeitetra.recipe;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.yiran.jeitetra.effect.ItemEffectIngredientTypeWithSubtypes;
import net.yiran.jeitetra.effect.ItemEffectLangManager;
import net.yiran.jeitetra.effect.ItemEffectRecipeIngredientRenderer;
import net.yiran.jeitetra.util.Drawables;
import net.yiran.jeitetra.util.I18nWrapper;
import net.yiran.jeitetra.util.ItemUtil;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;

public class EffectRecipeCategory
extends AbstractRecipeCategory<ItemEffect> {
    public static RecipeType<ItemEffect> recipeType = RecipeType.create((String)"jeitetra", (String)"effect", ItemEffect.class);
    public Minecraft mc = Minecraft.m_91087_();

    public EffectRecipeCategory(IGuiHelper guiHelper) {
        super(recipeType, (Component)Component.m_237115_((String)"jeitetra.alleffect.title"), guiHelper.createDrawableItemLike((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:pristine_quartz"))), 175, 200);
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, ItemEffect itemEffect, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 60, -1).setCustomRenderer((IIngredientType)ItemEffectIngredientTypeWithSubtypes.INSTANCE, (IIngredientRenderer)ItemEffectRecipeIngredientRenderer.INSTANCE).addIngredient((IIngredientType)ItemEffectIngredientTypeWithSubtypes.INSTANCE, (Object)itemEffect);
        List<ItemStack> items = EffectRecipeCategory.getItems(itemEffect);
        if (items == null || items.isEmpty()) {
            return;
        }
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 5, 1).setBackground(Drawables.SLOT, 0, 0).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, items);
    }

    public static List<ItemStack> getItems(ItemEffect itemEffect) {
        return DataManager.instance.materialData.getData().values().stream().filter(materialData -> materialData.effects.contains((Object)itemEffect)).map(materialData -> materialData.material.getPredicate()).filter(Objects::nonNull).map(ItemUtil::getItemsFromItemPredicate).flatMap(Collection::stream).toList();
    }

    public void draw(ItemEffect recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280398_(new ResourceLocation("jeitetra", "textures/gui/background2.png"), -8, -8, 0, 0.0f, 0.0f, 192, 220, 192, 220);
        Font font = this.mc.f_91062_;
        String effect = recipe.getKey();
        int left = (this.getWidth() - font.m_92895_(effect)) / 2;
        guiGraphics.m_280488_(font, "\u00a77" + effect, left, 10, -1);
        if (I18n.m_118936_((String)ItemEffectLangManager.instance.getDescKey(recipe))) {
            guiGraphics.m_280554_(font, FormattedText.m_130775_((String)I18nWrapper.getWithDefParam(ItemEffectLangManager.instance.getDescKey(recipe))), 6, 30, 163, -1);
        } else {
            guiGraphics.m_280056_(font, "\u00a77Cann't find any description in :", 6, 30, -1, false);
            guiGraphics.m_280056_(font, "\u00a78jeitetra.effect." + effect + ".desc", 6, 40, -1, false);
            guiGraphics.m_280056_(font, "\u00a78tetra.stats." + effect + ".tooltip", 6, 50, -1, false);
            guiGraphics.m_280056_(font, "\u00a78tetra.stats." + effect + ".tooltip_short", 6, 60, -1, false);
        }
    }
}

