/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.jeitetra.effect;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Unit;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.yiran.jeitetra.effect.ItemEffectLangHelper;
import se.mickelus.tetra.effect.ItemEffect;

public class ItemEffectLangManager {
    public static ItemEffectLangManager instance = new ItemEffectLangManager();
    public Map<ItemEffect, String> nameMap = new HashMap<ItemEffect, String>(100);
    public Map<ItemEffect, String> descMap = new HashMap<ItemEffect, String>(100);

    public void onReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
            reloadProfiler.m_7242_();
            reloadProfiler.m_6180_("listener");
            this.clearCache();
            reloadProfiler.m_7238_();
            reloadProfiler.m_7241_();
        }, gameExecutor));
    }

    public void clearCache() {
        this.nameMap.clear();
        this.descMap.clear();
    }

    public String getName(ItemEffect itemEffect) {
        return I18n.m_118938_((String)this.getNameKey(itemEffect), (Object[])new Object[0]);
    }

    public String getNameKey(ItemEffect effect) {
        if (this.nameMap.containsKey(effect)) {
            return this.nameMap.get(effect);
        }
        String name = ItemEffectLangHelper.getDisplayKey(effect);
        name = this.getEndLang(name);
        this.nameMap.put(effect, name);
        return name;
    }

    public String getDescKey(ItemEffect effect) {
        if (this.descMap.containsKey(effect)) {
            return this.descMap.get(effect);
        }
        String name = ItemEffectLangHelper.getDescKey(effect);
        name = this.getEndLang(name);
        this.descMap.put(effect, name);
        return name;
    }

    public String getEndLang(String key) {
        if (!I18n.m_118936_((String)key)) {
            return key;
        }
        String lang = I18n.m_118938_((String)key, (Object[])new Object[0]);
        if (lang.startsWith("goto:")) {
            return this.getEndLang(lang.substring(5));
        }
        return key;
    }
}

