/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.jeitetra.effect;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.TooltipFlag;
import net.yiran.jeitetra.effect.ItemEffectLangManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiTextures;

public class ItemEffectIngredientRenderer
implements IIngredientRenderer<ItemEffect> {
    public static final ItemEffectIngredientRenderer INSTANCE = new ItemEffectIngredientRenderer();

    public void render(GuiGraphics guiGraphics, ItemEffect itemEffect) {
        String effect;
        String sneakEffect;
        ResourceLocation resource;
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        Optional a = manager.m_213713_(resource = this.getResourceLocation(sneakEffect = (effect = itemEffect.getKey()).replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase()));
        if (a.isPresent()) {
            guiGraphics.m_280398_(resource, 0, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            char cha;
            Font font = Minecraft.m_91087_().f_91062_;
            int color = effect.hashCode() & 0xFFFFFF | 0xCC000000;
            String langKey = ItemEffectLangManager.instance.getNameKey(itemEffect);
            if (I18n.m_118936_((String)langKey)) {
                effect = I18n.m_118938_((String)langKey, (Object[])new Object[0]);
            }
            if (Character.isLowerCase(cha = (effect = effect.replaceAll("(\u00a7)(.)", "")).charAt(0))) {
                cha = Character.toUpperCase(cha);
            }
            String z = String.valueOf(cha);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(0.5, 0.5, 0.0);
            guiGraphics.m_280398_(GuiTextures.workbench, 0, 0, 0, 52.0f, 0.0f, 15, 15, 256, 256);
            guiGraphics.m_280168_().m_85837_(-0.1 - (double)(font.m_92865_().m_92353_(z) / 2.0f), -0.1, 0.0);
            guiGraphics.m_280056_(font, z, 8, 4, color, false);
            guiGraphics.m_280168_().m_85837_(-0.4, -0.4, 0.0);
            guiGraphics.m_280056_(font, z, 8, 4, -1, false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public ResourceLocation getResourceLocation(String name) {
        if (name.contains(":")) {
            return new ResourceLocation("jeitetra", "textures/effects/" + name.replace(":", "/") + ".png");
        }
        return new ResourceLocation("jeitetra", "textures/effects/tetra/" + name + ".png");
    }

    public List<Component> getTooltip(ItemEffect itemEffect, TooltipFlag tooltipFlag) {
        String effect = itemEffect.getKey();
        return List.of(Component.m_237115_((String)ItemEffectLangManager.instance.getNameKey(itemEffect)), Component.m_237113_((String)effect));
    }

    public void getTooltip(ITooltipBuilder tooltip, ItemEffect ingredient, TooltipFlag tooltipFlag) {
        tooltip.add((FormattedText)Component.m_237115_((String)ItemEffectLangManager.instance.getNameKey(ingredient)));
        tooltip.add((FormattedText)Component.m_237113_((String)ingredient.getKey()));
    }
}

