/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.jeitetra;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.yiran.jeitetra.Config;
import net.yiran.jeitetra.JEITetra;
import net.yiran.jeitetra.effect.ItemEffectIngredientHelper;
import net.yiran.jeitetra.effect.ItemEffectIngredientRenderer;
import net.yiran.jeitetra.effect.ItemEffectIngredientTypeWithSubtypes;
import net.yiran.jeitetra.effect.ItemEffectSimpleRecipeManagerPlugin;
import net.yiran.jeitetra.itemsubtype.ModularSubtypeInterpreter;
import net.yiran.jeitetra.itemsubtype.ScrollSubtypeInterpreter;
import net.yiran.jeitetra.material.MaterialIngredientHelper;
import net.yiran.jeitetra.material.MaterialIngredientRenderer;
import net.yiran.jeitetra.material.MaterialIngredientTypeWithSubtypes;
import net.yiran.jeitetra.material.MaterialSimpleRecipeManagerPlugin;
import net.yiran.jeitetra.module.ModuleSimpleRecipeManagerPlugin;
import net.yiran.jeitetra.recipe.ActionRecipeCategory;
import net.yiran.jeitetra.recipe.EffectRecipeCategory;
import net.yiran.jeitetra.recipe.MaterialRecipeCategory;
import net.yiran.jeitetra.recipe.ModuleRecipeCategory;
import net.yiran.jeitetra.recipe.ReplacementRecipeCategory;
import net.yiran.jeitetra.util.ModuleData;
import se.mickelus.mutil.data.DataStore;
import se.mickelus.tetra.ClientScheduler;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.data.VariantData;

@JeiPlugin
public class TetraPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeitetra", "common");
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(EffectRecipeCategory.recipeType, (ISimpleRecipeManagerPlugin)ItemEffectSimpleRecipeManagerPlugin.INSTANCE);
        registration.addTypedRecipeManagerPlugin(MaterialRecipeCategory.recipeType, (ISimpleRecipeManagerPlugin)MaterialSimpleRecipeManagerPlugin.INSTANCE);
        registration.addTypedRecipeManagerPlugin(ModuleRecipeCategory.recipeType, (ISimpleRecipeManagerPlugin)ModuleSimpleRecipeManagerPlugin.INSTANCE);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (((Boolean)Config.JeiSubtypeScrollItem.get()).booleanValue()) {
            registration.registerSubtypeInterpreter((Item)ScrollItem.instance, (IIngredientSubtypeInterpreter)ScrollSubtypeInterpreter.INSTANCE);
        }
        ((List)Config.JeiSubtypeModularItem.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull).forEach(item -> registration.registerSubtypeInterpreter(item, (IIngredientSubtypeInterpreter)ModularSubtypeInterpreter.INSTANCE));
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        List<ItemStack> list = CreativeModeTabRegistry.getSortedCreativeModeTabs().stream().map(CreativeModeTab::m_260957_).flatMap(Collection::stream).filter(stack -> stack.m_150930_((Item)ScrollItem.instance)).toList();
        registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, list, "scroll");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)ItemEffectIngredientTypeWithSubtypes.INSTANCE, (Boolean)Config.ShowAllEffects.get() != false ? TetraPlugin.getAllEffects() : List.of(), (IIngredientHelper)ItemEffectIngredientHelper.INSTANCE, (IIngredientRenderer)ItemEffectIngredientRenderer.INSTANCE);
        registration.register((IIngredientType)MaterialIngredientTypeWithSubtypes.INSTANCE, (Boolean)Config.ShowAllMaterials.get() != false ? DataManager.instance.materialData.getData().values().stream().toList() : List.of(), (IIngredientHelper)MaterialIngredientHelper.INSTANCE, (IIngredientRenderer)MaterialIngredientRenderer.INSTANCE);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ActionRecipeCategory(guiHelper), new ReplacementRecipeCategory(guiHelper), new EffectRecipeCategory(guiHelper), new MaterialRecipeCategory(guiHelper), new ModuleRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.currentSchedule(() -> {
            try {
                Class<ItemEffect> clazz = ItemEffect.class;
                Field flied = clazz.getDeclaredField("effectMap");
                flied.setAccessible(true);
                ArrayList effects = new ArrayList(((Map)flied.get(clazz)).values());
                registration.addRecipes(EffectRecipeCategory.recipeType, effects);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            registration.addRecipes(ActionRecipeCategory.recipeType, this.flatData((DataStore<T[]>)DataManager.instance.actionData));
            registration.addRecipes(ReplacementRecipeCategory.recipeType, this.flatData((DataStore<T[]>)DataManager.instance.replacementData));
            registration.addRecipes(MaterialRecipeCategory.recipeType, DataManager.instance.materialData.getData().values().stream().toList());
            registration.addRecipes(ModuleRecipeCategory.recipeType, ModuleRegistry.instance.getAllModules().stream().flatMap(module -> Arrays.stream(module.getVariantData()).map(variantData -> new ModuleData((ItemModule)module, (VariantData)variantData))).toList());
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        Item basicWorkbench = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:basic_workbench"));
        Item forgedWorkbench = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:forged_workbench"));
        registration.addRecipeCatalysts(ActionRecipeCategory.recipeType, new ItemLike[]{basicWorkbench, forgedWorkbench});
        registration.addRecipeCatalysts(ReplacementRecipeCategory.recipeType, new ItemLike[]{basicWorkbench, forgedWorkbench});
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        if (!((Boolean)Config.OutputReplacementItem.get()).booleanValue()) {
            return;
        }
        registration.addExtraItemStacks(DataManager.instance.replacementData.getData().values().stream().flatMap(Arrays::stream).map(r -> r.itemStack).toList());
    }

    public <T> List<T> flatData(DataStore<T[]> store) {
        return store.getData().values().stream().flatMap(Arrays::stream).toList();
    }

    public void currentSchedule(Runnable run) {
        if (JEITetra.TMRVLOAD) {
            run.run();
        } else if (FMLEnvironment.dist.isClient()) {
            ClientScheduler.schedule((int)1, (Runnable)run);
        } else {
            ServerScheduler.schedule((int)1, (Runnable)run);
        }
    }

    public static List<ItemEffect> getAllEffects() {
        try {
            Class<ItemEffect> clazz = ItemEffect.class;
            Field field = clazz.getDeclaredField("effectMap");
            field.setAccessible(true);
            return new ArrayList<ItemEffect>(((Map)field.get(clazz)).values());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

