/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.mixin;

import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.block.custom.LanternButton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChainBlock.class})
public abstract class ChainBlockMixin
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public ChainBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.checkAround(blockState, blockAccess, pos) && side == Direction.DOWN ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.checkAround(blockState, blockAccess, pos) && side == Direction.DOWN ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean checkAround(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_61143_((Property)f_55923_) != Direction.Axis.Y || world.m_8055_(pos.m_7494_()).m_60734_() instanceof ChainBlock) {
            return false;
        }
        int i = 1;
        while (world.m_8055_(pos.m_6625_(i)).m_60734_() instanceof ChainBlock) {
            if (world.m_8055_(pos.m_6625_(i)).m_61143_((Property)f_55923_) != Direction.Axis.Y) {
                return false;
            }
            ++i;
        }
        BlockState blockState = world.m_8055_(pos.m_6625_(i));
        if (!(blockState.m_60734_() instanceof LanternButton)) {
            return false;
        }
        return (Boolean)blockState.m_61143_((Property)LanternButton.PRESSED);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        int distance = InfinityButtonsUtil.checkChains(worldIn, pos);
        if (distance > 0) {
            worldIn.m_46586_(pos.m_6630_(distance), (Block)this, pos);
        } else {
            worldIn.m_46586_(pos.m_7494_(), (Block)this, pos);
            worldIn.m_46590_(pos.m_7494_(), (Block)this, Direction.DOWN);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        int distance = InfinityButtonsUtil.checkChains(world, pos);
        if (distance == 0) {
            world.m_46590_(pos.m_7494_(), (Block)this, Direction.DOWN);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }
}

