/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.compat;

import java.util.function.Supplier;
import net.larsmans.infinitybuttons.InfinityButtons;
import net.larsmans.infinitybuttons.block.InfinityButtonsBlocks;
import net.larsmans.infinitybuttons.block.custom.secretbutton.compat.ChiseledCompatSecretButton;
import net.larsmans.infinitybuttons.block.custom.secretbutton.compat.CompatBookshelfSecretButton;
import net.larsmans.infinitybuttons.item.InfinityButtonsItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalBlocks {
    public static final RegistryObject<Block> WILLOW_BOOKSHELF_SECRET_BUTTON = EnvironmentalBlocks.registerBookshelf("willow");
    public static final RegistryObject<Block> CHERRY_BOOKSHELF_SECRET_BUTTON = EnvironmentalBlocks.registerBookshelf("cherry");
    public static final RegistryObject<Block> WISTERIA_BOOKSHELF_SECRET_BUTTON = EnvironmentalBlocks.registerBookshelf("wisteria");
    public static final RegistryObject<Block> CHISELED_MUD_BRICK_SECRET_BUTTON = EnvironmentalBlocks.registerBlock("chiseled_mud_brick_secret_button", () -> new ChiseledCompatSecretButton(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60913_(1.5f, 2.5f).m_60955_().m_60918_(SoundType.f_56742_).m_60999_(), EnvironmentalBlocks.byName("chiseled_mud_bricks")));

    private static Block byName(String block) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("environmental", block));
    }

    private static RegistryObject<Block> registerBookshelf(String wood) {
        return EnvironmentalBlocks.registerBlock(wood + "_bookshelf_secret_button", () -> new CompatBookshelfSecretButton(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_60978_(1.5f).m_60955_().m_60918_(SoundType.f_56736_), EnvironmentalBlocks.byName(wood + "_bookshelf")));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = InfinityButtonsBlocks.BLOCKS.register(name, block);
        EnvironmentalBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        InfinityButtonsItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void registerCompatBlocks() {
        InfinityButtons.LOGGER.debug("Registering Environmental Compat Blocks for Infinity Buttons");
    }
}

