/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.compat;

import java.util.function.Supplier;
import net.larsmans.infinitybuttons.InfinityButtons;
import net.larsmans.infinitybuttons.block.InfinityButtonsBlocks;
import net.larsmans.infinitybuttons.block.custom.button.compat.FallingCompatButton;
import net.larsmans.infinitybuttons.block.custom.secretbutton.compat.CompatBookshelfSecretButton;
import net.larsmans.infinitybuttons.item.InfinityButtonsItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AtmosphericBlocks {
    public static final RegistryObject<Block> ARID_SAND_BUTTON = AtmosphericBlocks.registerSandButton("arid_sand");
    public static final RegistryObject<Block> RED_ARID_SAND_BUTTON = AtmosphericBlocks.registerSandButton("red_arid_sand");
    public static final RegistryObject<Block> ARID_SAND_LARGE_BUTTON = AtmosphericBlocks.registerSandLargeButton("arid_sand");
    public static final RegistryObject<Block> RED_ARID_SAND_LARGE_BUTTON = AtmosphericBlocks.registerSandLargeButton("red_arid_sand");
    public static final RegistryObject<Block> ROSEWOOD_BOOKSHELF_SECRET_BUTTON = AtmosphericBlocks.registerBookshelf("rosewood");
    public static final RegistryObject<Block> MORADO_BOOKSHELF_SECRET_BUTTON = AtmosphericBlocks.registerBookshelf("morado");
    public static final RegistryObject<Block> YUCCA_BOOKSHELF_SECRET_BUTTON = AtmosphericBlocks.registerBookshelf("yucca");
    public static final RegistryObject<Block> KOUSA_BOOKSHELF_SECRET_BUTTON = AtmosphericBlocks.registerBookshelf("kousa");
    public static final RegistryObject<Block> ASPEN_BOOKSHELF_SECRET_BUTTON = AtmosphericBlocks.registerBookshelf("aspen");
    public static final RegistryObject<Block> GRIMWOOD_BOOKSHELF_SECRET_BUTTON = AtmosphericBlocks.registerBookshelf("grimwood");

    private static Block byName(String block) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric", block));
    }

    private static RegistryObject<Block> registerSandButton(String type) {
        return AtmosphericBlocks.registerBlock(type + "_button", () -> new FallingCompatButton(false, BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60910_().m_60918_(SoundType.f_56746_), false));
    }

    private static RegistryObject<Block> registerSandLargeButton(String type) {
        return AtmosphericBlocks.registerBlock(type + "_large_button", () -> new FallingCompatButton(false, BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60910_().m_60918_(SoundType.f_56746_), true));
    }

    private static RegistryObject<Block> registerBookshelf(String wood) {
        return AtmosphericBlocks.registerBlock(wood + "_bookshelf_secret_button", () -> new CompatBookshelfSecretButton(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_60978_(1.5f).m_60955_().m_60918_(SoundType.f_56736_), AtmosphericBlocks.byName(wood + "_bookshelf")));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = InfinityButtonsBlocks.BLOCKS.register(name, block);
        AtmosphericBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        InfinityButtonsItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void registerCompatBlocks() {
        InfinityButtons.LOGGER.debug("Registering Atmospheric Compat Blocks for Infinity Buttons");
    }
}

